/*
 * Decompiled with CFR 0.152.
 */
package org.metamechanists.quaptics.panels.config.implementation;

import java.util.Objects;
import java.util.Optional;
import org.bukkit.Location;
import org.bukkit.entity.Player;
import org.bukkit.util.Vector;
import org.jetbrains.annotations.NotNull;
import org.metamechanists.quaptics.connections.ConnectionGroup;
import org.metamechanists.quaptics.implementation.blocks.consumers.ItemProjector;
import org.metamechanists.quaptics.items.Lore;
import org.metamechanists.quaptics.panels.config.ConfigPanel;
import org.metamechanists.quaptics.panels.config.ConfigPanelBuilder;
import org.metamechanists.quaptics.panels.config.ConfigPanelContainer;
import org.metamechanists.quaptics.utils.BlockStorageAPI;
import org.metamechanists.quaptics.utils.Utils;
import org.metamechanists.quaptics.utils.id.complex.ConfigPanelId;
import org.metamechanists.quaptics.utils.id.complex.ConnectionGroupId;

public class ItemProjectorConfigPanel
extends ConfigPanel {
    public ItemProjectorConfigPanel(@NotNull Location location, ConnectionGroupId groupId, float rotationY) {
        super(groupId, location, rotationY);
    }

    public ItemProjectorConfigPanel(@NotNull ConfigPanelId id, ConnectionGroupId groupId) {
        super(id, groupId);
    }

    @Override
    protected ConfigPanelContainer buildPanelContainer(@NotNull ConnectionGroupId groupId, @NotNull Location location, float rotationY) {
        return new ConfigPanelBuilder(groupId, location.clone().add(this.getOffset()), 0.3f, rotationY).addAttribute("height", "&fHeight").addAttribute("size", "&fSize").addAttribute("mode", "&fMode").build();
    }

    @Override
    public void interact(@NotNull Player player, @NotNull Location location, String name, String type) {
        if ("height".equals(name)) {
            double height = BlockStorageAPI.getDouble(location, "QP_HEIGHT");
            height += "add".equals(type) ? 1.0 : -1.0;
            height = Utils.clampToRange(height, 0.0, 20.0);
            BlockStorageAPI.set(location, "QP_HEIGHT", height);
        }
        if ("size".equals(name)) {
            double size = BlockStorageAPI.getDouble(location, "QP_SIZE");
            size += "add".equals(type) ? 1.0 : -1.0;
            size = Utils.clampToRange(size, 0.0, 20.0);
            BlockStorageAPI.set(location, "QP_SIZE", size);
        }
        if ("mode".equals(name)) {
            int size = BlockStorageAPI.getInt(location, "QP_MODE");
            size += "add".equals(type) ? 1 : -1;
            size = Utils.clampToRange(size, 0, 3);
            BlockStorageAPI.set(location, "QP_MODE", size);
        }
        ItemProjector.onConfigUpdated(location);
        this.update();
    }

    @Override
    protected void update() {
        if (this.isPanelHidden()) {
            return;
        }
        Optional<ConnectionGroup> group = this.getGroup();
        if (group.isEmpty()) {
            return;
        }
        Optional<Location> location = group.get().getLocation();
        if (location.isEmpty()) {
            return;
        }
        double height = BlockStorageAPI.getDouble(location.get(), "QP_HEIGHT");
        double size = BlockStorageAPI.getDouble(location.get(), "QP_SIZE");
        int mode = BlockStorageAPI.getInt(location.get(), "QP_MODE");
        this.container.setValue("height", Lore.progressBar(height, 20.0, "&b", "&8", "&b"));
        this.container.setValue("size", Lore.progressBar(size, 20.0, "&b", "&8", "&b"));
        this.container.setValue("mode", Objects.toString(mode));
    }

    @Override
    protected Vector getOffset() {
        return new Vector(0.0, -0.3, 0.0);
    }
}

