/*
 * Decompiled with CFR 0.152.
 */
package org.metamechanists.quaptics.items;

import io.github.thebusybiscuit.slimefun4.utils.LoreBuilder;
import java.text.DecimalFormat;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import org.jetbrains.annotations.NotNull;
import org.metamechanists.quaptics.implementation.Settings;
import org.metamechanists.quaptics.utils.Colors;

public final class Lore {
    private static final double ROUND_TO_INT_THRESHOLD = 1.0E-4;
    public static final String ATTRIBUTE_SYMBOL = "&8\u21e8 ";
    public static final String COUNT_SYMBOL = Colors.QUAPTIC_COMPONENTS.getFormattedColor() + "\u25ce ";
    public static final String RANGE_SYMBOL = Colors.QUAPTIC_COMPONENTS.getFormattedColor() + "\u2194 ";
    public static final String SPEED_SYMBOL = Colors.QUAPTIC_COMPONENTS.getFormattedColor() + "\u2192 ";
    public static final String DAMAGE_SYMBOL = Colors.QUAPTIC_COMPONENTS.getFormattedColor() + "\ud83d\udde1 ";
    public static final String CHARGE_SYMBOL = Colors.CHARGE.getFormattedColor() + "\u25c6 ";
    public static final String POWER_SYMBOL = Colors.POWER.getFormattedColor() + "\u23fb ";
    public static final String FREQUENCY_SYMBOL = Colors.FREQUENCY.getFormattedColor() + "\u2200 ";
    public static final String PHASE_SYMBOL = Colors.PHASE.getFormattedColor() + "\u06de ";
    public static final String PERCENTAGE_SUFFIX = " &8%";
    public static final String CHARGE_SUFFIX = " &8QEU";
    public static final String POWER_SUFFIX = " &8W";
    public static final String RANGE_SUFFIX = " &8blocks";
    public static final String DAMAGE_SUFFIX = " &8dps";
    public static final String FREQUENCY_SUFFIX = " &8Hz";
    public static final String SECONDS_SUFFIX = " &8seconds";
    public static final String MINUTES_SUFFIX = " &8minutes";
    public static final String PHASE_SUFFIX = " &8\u00b0";
    public static final String MULTIBLOCK_SYMBOL = "&3\u2605";
    private static final double SLIMEFUN_TICKS_PER_SECOND = 2.0;

    @NotNull
    private static DecimalFormat getDecimalFormat0dp() {
        DecimalFormat decimalFormat = new DecimalFormat("#");
        decimalFormat.setGroupingUsed(true);
        decimalFormat.setGroupingSize(3);
        return decimalFormat;
    }

    @NotNull
    private static DecimalFormat getDecimalFormat1dp() {
        DecimalFormat decimalFormat = new DecimalFormat("#.0");
        decimalFormat.setGroupingUsed(true);
        decimalFormat.setGroupingSize(3);
        return decimalFormat;
    }

    @NotNull
    private static DecimalFormat getDecimalFormat2dp() {
        DecimalFormat decimalFormat = new DecimalFormat("#.00");
        decimalFormat.setGroupingUsed(true);
        decimalFormat.setGroupingSize(3);
        return decimalFormat;
    }

    private static String formatZeroDp(double x) {
        return Lore.getDecimalFormat0dp().format(x);
    }

    private static String formatOneDp(double x) {
        return Lore.getDecimalFormat1dp().format(x);
    }

    private static String formatTwoDp(double x) {
        return Lore.getDecimalFormat2dp().format(x);
    }

    @NotNull
    public static String[] buildChargeableLore(@NotNull Settings settings, int charge, String ... description) {
        ArrayList<String> lore = new ArrayList<String>();
        Collections.addAll(lore, description);
        lore.add(Lore.chargeBar(charge, (int)settings.getChargeCapacity()));
        lore.add(Lore.chargeValues(charge, (int)settings.getChargeCapacity()));
        lore.add(Lore.chargePerUse((int)settings.getOutputPower()));
        if (settings.getMinFrequency() != 0.0 || settings.getMaxFrequency() != 0.0) {
            lore.add(Lore.operatingFrequency(settings.getMinFrequency(), settings.getMaxFrequency()));
        }
        return lore.toArray(new String[0]);
    }

    @NotNull
    private static List<String> fromSettings(@NotNull Settings settings) {
        ArrayList<String> lore = new ArrayList<String>();
        if (settings.getTier() != null && !settings.isOperatingPowerHidden()) {
            if (settings.isMaxPowerHidden()) {
                lore.add(Lore.minPower(settings.getMinPower()));
            } else {
                lore.add(Lore.operatingPower(settings.getMinPower(), settings.getTier().maxPower));
            }
        }
        if (settings.getPowerThreshold() != 0.0) {
            lore.add(Lore.powerThreshold(settings.getPowerThreshold()));
        }
        if (settings.getOutputPower() != 0.0) {
            lore.add(Lore.powerOutput(settings.getOutputPower()));
        }
        if (settings.getMaxOutputPower() != 0.0) {
            lore.add(Lore.maxPowerOutput(settings.getMaxOutputPower()));
        }
        if (settings.getPowerLoss() != 0.0) {
            lore.add(Lore.powerLoss(settings.getPowerLoss()));
        }
        if (settings.getPowerMultiplier() != 0.0) {
            lore.add(Lore.powerMultiplier(settings.getPowerMultiplier()));
        }
        if (settings.getChargeCapacity() != 0.0) {
            lore.add(Lore.capacity(settings.getChargeCapacity()));
        }
        if (settings.getMaxFrequency() != 0.0 || settings.getMinFrequency() != 0.0) {
            lore.add(Lore.operatingFrequency(settings.getMinFrequency(), settings.getMaxFrequency()));
        }
        if (settings.getFrequencyStep() != 0.0) {
            lore.add(Lore.frequencyStep(settings.getFrequencyStep()));
        }
        if (settings.getFrequencyMultiplier() != 0.0) {
            lore.add(Lore.frequencyMultiplier(settings.getFrequencyMultiplier()));
        }
        if (settings.getConnections() != 0) {
            lore.add(Lore.maxConnections(settings.getConnections()));
        }
        if (settings.getRange() != 0) {
            lore.add(Lore.range(settings.getRange()));
        }
        if (settings.getDamage() != 0.0) {
            lore.add(Lore.damage(settings.getDamage()));
        }
        if (settings.getUseInterval() != 0.0) {
            lore.add(Lore.useInterval(settings.getUseInterval() / 20.0));
        }
        if (settings.getTimePerRecipe() != 0.0) {
            lore.add(Lore.timePerRecipe(settings.getTimePerRecipe()));
        }
        if (settings.getTimeToMaxEfficiency() != 0) {
            lore.add(Lore.timeToMaxEfficiency((double)settings.getTimeToMaxEfficiency() / 60.0));
        }
        if (settings.getTargetPhase() != 0) {
            lore.add(Lore.targetPhase(settings.getTargetPhase()));
        }
        if (settings.getLuckLevel() != 0) {
            lore.add(Lore.luckLevel(settings.getLuckLevel()));
        }
        if (settings.getFireResistanceLevel() != 0) {
            lore.add(Lore.fireResistanceLevel(settings.getFireResistanceLevel()));
        }
        if (settings.getExperienceMultiplier() != 0.0) {
            lore.add(Lore.experienceMultiplier(settings.getExperienceMultiplier()));
        }
        if (settings.getPowerEfficiency() != 0.0) {
            lore.add(Lore.powerEfficiency(settings.getPowerEfficiency()));
        }
        if (settings.getEnergyConsumption() != 0) {
            lore.add(LoreBuilder.powerPerSecond((int)(settings.getEnergyConsumption() * 2)));
        }
        return lore;
    }

    @NotNull
    public static String[] create(@NotNull Settings settings, String ... description) {
        ArrayList<String> lore = new ArrayList<String>();
        lore.add(settings.getTier().name);
        Collections.addAll(lore, description);
        lore.addAll(Lore.fromSettings(settings));
        return lore.toArray(new String[0]);
    }

    public static String clickToOpen() {
        return "&8\u21e8 &7Click to open";
    }

    public static String multiblock() {
        return MULTIBLOCK_SYMBOL + Colors.MULTIBLOCKS.getFormattedColor() + " Multiblock &8(right click with the Multiblock Wand)";
    }

    public static String multiblockComponent() {
        return MULTIBLOCK_SYMBOL + Colors.MULTIBLOCKS.getFormattedColor() + " Multiblock Component";
    }

    public static String maxConnections(int maxConnections) {
        return ATTRIBUTE_SYMBOL + COUNT_SYMBOL + "&7Max connections: &e" + Objects.toString(maxConnections);
    }

    public static String range(int range) {
        return ATTRIBUTE_SYMBOL + RANGE_SYMBOL + "&7Range &e" + Objects.toString(range) + RANGE_SUFFIX;
    }

    public static String damage(double damage) {
        return ATTRIBUTE_SYMBOL + DAMAGE_SYMBOL + "&7Damage &e" + Lore.formatOneDp(damage / 2.0) + DAMAGE_SUFFIX;
    }

    public static String useInterval(double useInterval) {
        return ATTRIBUTE_SYMBOL + SPEED_SYMBOL + "&7Use Interval &e" + Lore.formatOneDp(useInterval) + SECONDS_SUFFIX;
    }

    public static String timePerRecipe(double timePerRecipe) {
        return ATTRIBUTE_SYMBOL + SPEED_SYMBOL + "&7Time per recipe &e" + Lore.formatOneDp(timePerRecipe) + SECONDS_SUFFIX;
    }

    public static String timeToMaxEfficiency(double timeToMaxEfficiency) {
        return ATTRIBUTE_SYMBOL + SPEED_SYMBOL + "&7Time to max efficiency &e" + Lore.formatZeroDp(timeToMaxEfficiency) + MINUTES_SUFFIX;
    }

    public static String luckLevel(int luckLevel) {
        return ATTRIBUTE_SYMBOL + COUNT_SYMBOL + "&7Luck Level &e" + Lore.formatZeroDp(luckLevel);
    }

    public static String fireResistanceLevel(int fireResistanceLevel) {
        return ATTRIBUTE_SYMBOL + COUNT_SYMBOL + "&7Fire Resistance Level &e" + Lore.formatZeroDp(fireResistanceLevel);
    }

    public static String experienceMultiplier(double experienceMultiplier) {
        return ATTRIBUTE_SYMBOL + COUNT_SYMBOL + "&7Experience Multiplier &e" + Lore.formatZeroDp(experienceMultiplier) + "x";
    }

    public static String powerInfoPanel(double power) {
        return POWER_SYMBOL + "&7Power &e" + Lore.formatTwoDp(power) + POWER_SUFFIX;
    }

    public static String minPower(double minPower) {
        return ATTRIBUTE_SYMBOL + POWER_SYMBOL + "&7Operating Power &e" + Lore.formatZeroDp(minPower) + "+ &8W";
    }

    public static String powerOutput(double powerOutput) {
        return ATTRIBUTE_SYMBOL + POWER_SYMBOL + "&7Power Output &e" + Lore.formatZeroDp(powerOutput) + POWER_SUFFIX;
    }

    public static String powerThreshold(double powerThreshold) {
        return ATTRIBUTE_SYMBOL + POWER_SYMBOL + "&7Power Threshold &e" + Lore.formatZeroDp(powerThreshold) + POWER_SUFFIX;
    }

    public static String maxPowerOutput(double maxPowerOutput) {
        return ATTRIBUTE_SYMBOL + POWER_SYMBOL + "&7Max Power Output &e" + Lore.formatZeroDp(maxPowerOutput) + POWER_SUFFIX;
    }

    public static String operatingPower(double minPower, double maxPower) {
        return ATTRIBUTE_SYMBOL + POWER_SYMBOL + "&7Operating Power &e" + Lore.formatZeroDp(minPower) + " &7- &e" + Lore.formatZeroDp(maxPower) + POWER_SUFFIX;
    }

    public static String powerLoss(double powerLoss) {
        return ATTRIBUTE_SYMBOL + POWER_SYMBOL + "&7Power Loss &e" + Lore.formatZeroDp(powerLoss * 100.0) + PERCENTAGE_SUFFIX;
    }

    public static String powerMultiplier(double powerMultiplier) {
        return ATTRIBUTE_SYMBOL + POWER_SYMBOL + "&7Power Multiplier &e" + Lore.formatZeroDp(powerMultiplier * 100.0) + PERCENTAGE_SUFFIX;
    }

    public static String powerOutput(double outputPower, double maxOutputPower) {
        return (outputPower >= maxOutputPower ? "&a" : "&6") + Lore.formatZeroDp(outputPower) + "&7 / &a" + Lore.formatZeroDp(maxOutputPower);
    }

    public static String powerEfficiency(double powerEfficiency) {
        return ATTRIBUTE_SYMBOL + POWER_SYMBOL + "&7Power Efficiency &e" + Lore.formatTwoDp(powerEfficiency) + POWER_SUFFIX;
    }

    public static String chargeValues(double charge, double capacity) {
        return ATTRIBUTE_SYMBOL + CHARGE_SYMBOL + "&7" + Lore.formatZeroDp(charge) + " &8/ &7" + Lore.formatZeroDp(capacity) + CHARGE_SUFFIX;
    }

    public static String chargeValuesRaw(double charge, double capacity) {
        return "&7" + Lore.formatZeroDp(charge) + " &8/ &7" + Lore.formatZeroDp(capacity) + CHARGE_SUFFIX;
    }

    public static String chargePerUse(double usage) {
        return ATTRIBUTE_SYMBOL + POWER_SYMBOL + "&7Charge per use &e" + Lore.formatZeroDp(usage) + CHARGE_SUFFIX;
    }

    public static String capacity(double capacity) {
        return ATTRIBUTE_SYMBOL + CHARGE_SYMBOL + "&7Capacity &e" + Lore.formatZeroDp(capacity) + CHARGE_SUFFIX;
    }

    public static String frequencyInfoPanel(double frequency) {
        return FREQUENCY_SYMBOL + "&7Frequency &e" + Lore.formatTwoDp(frequency) + FREQUENCY_SUFFIX;
    }

    public static String operatingFrequency(double minFrequency, double maxFrequency) {
        return ATTRIBUTE_SYMBOL + FREQUENCY_SYMBOL + "&7Operating Frequency &e" + Lore.formatZeroDp(minFrequency) + (String)(maxFrequency == 0.0 ? "+" : " &7- &e" + Lore.formatZeroDp(maxFrequency)) + FREQUENCY_SUFFIX;
    }

    public static String frequencyStep(double frequencyStep) {
        return ATTRIBUTE_SYMBOL + FREQUENCY_SYMBOL + "&7Frequency &e+" + Lore.formatOneDp(frequencyStep) + FREQUENCY_SUFFIX;
    }

    public static String frequencyMultiplier(double frequencyMultiplier) {
        return ATTRIBUTE_SYMBOL + FREQUENCY_SYMBOL + "&7Frequency &ex" + Lore.formatOneDp(frequencyMultiplier);
    }

    public static String phaseInfoPanel(int phase) {
        return PHASE_SYMBOL + "&7Phase &e" + Objects.toString(phase) + PHASE_SUFFIX;
    }

    public static String targetPhase(int targetPhase) {
        return ATTRIBUTE_SYMBOL + PHASE_SYMBOL + "&7Target Phase &e" + Objects.toString(targetPhase) + PHASE_SUFFIX;
    }

    public static String phaseChange(int phaseChange) {
        return ATTRIBUTE_SYMBOL + PHASE_SYMBOL + "&7Phase Change &e" + Objects.toString(phaseChange) + PHASE_SUFFIX;
    }

    public static String progressBar(double value, double max, String filledColor, String emptyColor, String finishedColor) {
        String base = "\u00a6\u00a6\u00a6\u00a6\u00a6\u00a6\u00a6\u00a6\u00a6\u00a6\u00a6\u00a6\u00a6\u00a6\u00a6\u00a6\u00a6\u00a6\u00a6\u00a6";
        if (value >= max) {
            return finishedColor + "\u00a6\u00a6\u00a6\u00a6\u00a6\u00a6\u00a6\u00a6\u00a6\u00a6\u00a6\u00a6\u00a6\u00a6\u00a6\u00a6\u00a6\u00a6\u00a6\u00a6";
        }
        int divideAt = (int)(value / (max / 20.0));
        return filledColor + "\u00a6\u00a6\u00a6\u00a6\u00a6\u00a6\u00a6\u00a6\u00a6\u00a6\u00a6\u00a6\u00a6\u00a6\u00a6\u00a6\u00a6\u00a6\u00a6\u00a6".substring(0, divideAt) + emptyColor + "\u00a6\u00a6\u00a6\u00a6\u00a6\u00a6\u00a6\u00a6\u00a6\u00a6\u00a6\u00a6\u00a6\u00a6\u00a6\u00a6\u00a6\u00a6\u00a6\u00a6".substring(divideAt);
    }

    public static String twoWayProgressBar(double value, double max, String negativeColor, String positiveColor, String emptyColor) {
        int divideAt = (int)(value / (max / 10.0));
        Object firstHalf = "\u00a6\u00a6\u00a6\u00a6\u00a6\u00a6\u00a6\u00a6\u00a6\u00a6";
        Object secondHalf = "\u00a6\u00a6\u00a6\u00a6\u00a6\u00a6\u00a6\u00a6\u00a6\u00a6";
        if (divideAt < 0) {
            firstHalf = ((String)firstHalf).substring(0, divideAt += 10) + negativeColor + ((String)firstHalf).substring(divideAt);
        } else if (divideAt > 0) {
            secondHalf = positiveColor + ((String)secondHalf).substring(0, divideAt) + emptyColor + ((String)secondHalf).substring(divideAt);
        }
        return emptyColor + (String)firstHalf + emptyColor + (String)secondHalf;
    }

    public static String thresholdBar(double inputPower, double minInputPower) {
        return Lore.progressBar(inputPower, minInputPower, "&6", "&8", "&a");
    }

    public static String efficiencyBar(double secondsSinceStarted, double maxSeconds) {
        return Lore.progressBar(secondsSinceStarted, maxSeconds, "&6", "&8", "&a");
    }

    public static String chargeBar(double charge, double capacity) {
        return ATTRIBUTE_SYMBOL + CHARGE_SYMBOL + "&7Charge " + Lore.progressBar(charge, capacity, Colors.CHARGE.getFormattedColor(), "&8", Colors.CHARGE.getFormattedColor());
    }

    public static String chargeBarRaw(double charge, double capacity) {
        return Lore.progressBar(charge, capacity, Colors.CHARGE.getFormattedColor(), "&8", Colors.CHARGE.getFormattedColor());
    }

    private Lore() {
        throw new UnsupportedOperationException("This is a utility class and cannot be instantiated");
    }
}

