/*
 * Decompiled with CFR 0.152.
 */
package org.metamechanists.quaptics.implementation.tools.targetingwand;

import io.github.thebusybiscuit.slimefun4.api.items.SlimefunItem;
import java.util.Optional;
import org.bukkit.entity.Entity;
import org.bukkit.entity.EntityType;
import org.bukkit.entity.Player;
import org.bukkit.event.EventHandler;
import org.bukkit.event.EventPriority;
import org.bukkit.event.Listener;
import org.bukkit.event.player.PlayerInteractEntityEvent;
import org.bukkit.event.player.PlayerItemHeldEvent;
import org.bukkit.inventory.ItemStack;
import org.jetbrains.annotations.NotNull;
import org.metamechanists.quaptics.implementation.tools.targetingwand.TargetingWand;
import org.metamechanists.quaptics.utils.id.complex.ConnectionPointId;

public class TargetingWandListener
implements Listener {
    private static void useWand(Player player, @NotNull ConnectionPointId id, TargetingWand wand, ItemStack itemStack) {
        if (((Optional)id.get()).isEmpty()) {
            return;
        }
        wand.use(player, id, itemStack);
    }

    @EventHandler(priority=EventPriority.MONITOR, ignoreCancelled=true)
    public static void interactEvent(@NotNull PlayerInteractEntityEvent event) {
        Entity clickedEntity = event.getRightClicked();
        if (clickedEntity.getType() != EntityType.INTERACTION) {
            return;
        }
        ItemStack mainHandItem = event.getPlayer().getInventory().getItemInMainHand();
        ItemStack offHandItem = event.getPlayer().getInventory().getItemInOffHand();
        ConnectionPointId pointId = new ConnectionPointId(clickedEntity.getUniqueId());
        SlimefunItem slimefunItem = SlimefunItem.getByItem((ItemStack)mainHandItem);
        if (slimefunItem instanceof TargetingWand) {
            TargetingWand wand = (TargetingWand)slimefunItem;
            TargetingWandListener.useWand(event.getPlayer(), pointId, wand, mainHandItem);
            return;
        }
        slimefunItem = SlimefunItem.getByItem((ItemStack)offHandItem);
        if (slimefunItem instanceof TargetingWand) {
            TargetingWand wand = (TargetingWand)slimefunItem;
            TargetingWandListener.useWand(event.getPlayer(), pointId, wand, offHandItem);
        }
    }

    @EventHandler
    public static void scrollEvent(@NotNull PlayerItemHeldEvent event) {
        ItemStack heldItem = event.getPlayer().getInventory().getItem(event.getPreviousSlot());
        if (SlimefunItem.getByItem((ItemStack)heldItem) instanceof TargetingWand) {
            TargetingWand.unsetSource(heldItem);
        }
    }
}

