/*
 * Decompiled with CFR 0.152.
 */
package org.metamechanists.quaptics.implementation.multiblocks.entangler;

import com.destroystokyo.paper.ParticleBuilder;
import io.github.thebusybiscuit.slimefun4.api.items.ItemGroup;
import io.github.thebusybiscuit.slimefun4.api.items.SlimefunItemStack;
import io.github.thebusybiscuit.slimefun4.api.recipes.RecipeType;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import org.bukkit.Location;
import org.bukkit.Material;
import org.bukkit.Particle;
import org.bukkit.entity.Player;
import org.bukkit.inventory.ItemStack;
import org.bukkit.util.Vector;
import org.jetbrains.annotations.NotNull;
import org.metamechanists.quaptics.connections.ConnectionGroup;
import org.metamechanists.quaptics.connections.ConnectionPoint;
import org.metamechanists.quaptics.displaymodellib.models.ModelBuilder;
import org.metamechanists.quaptics.displaymodellib.models.components.ModelItem;
import org.metamechanists.quaptics.displaymodellib.models.components.ModelLine;
import org.metamechanists.quaptics.displaymodellib.sefilib.entity.display.DisplayGroup;
import org.metamechanists.quaptics.implementation.Settings;
import org.metamechanists.quaptics.implementation.attachments.ComplexMultiblock;
import org.metamechanists.quaptics.implementation.attachments.ItemHolderBlock;
import org.metamechanists.quaptics.implementation.attachments.ItemProcessor;
import org.metamechanists.quaptics.implementation.base.ConnectedBlock;
import org.metamechanists.quaptics.implementation.multiblocks.entangler.EntanglementMagnet;
import org.metamechanists.quaptics.items.Lore;
import org.metamechanists.quaptics.items.Tier;
import org.metamechanists.quaptics.items.groups.CraftingComponents;
import org.metamechanists.quaptics.utils.BlockStorageAPI;
import org.metamechanists.quaptics.utils.Language;
import org.metamechanists.quaptics.utils.Particles;
import org.metamechanists.quaptics.utils.id.complex.ConnectionGroupId;

public class EntanglementContainer
extends ConnectedBlock
implements ItemHolderBlock,
ComplexMultiblock,
ItemProcessor {
    public static final Settings ENTANGLEMENT_CONTAINER_SETTINGS = Settings.builder().tier(Tier.INTERMEDIATE).timePerRecipe(5.0).build();
    public static final SlimefunItemStack ENTANGLEMENT_CONTAINER = new SlimefunItemStack("QP_ENTANGLEMENT_CONTAINER", Material.CYAN_CONCRETE, "&6Entanglement Container", Lore.create(ENTANGLEMENT_CONTAINER_SETTINGS, Lore.multiblock(), "&7\u25cf Entangles items", "&7\u25cf &eRight Click &7with an item to start the entanglement process"));
    private static final Map<Vector, ItemStack> MAGNETS = Map.of(new Vector(3, 0, 0), EntanglementMagnet.ENTANGLEMENT_MAGNET, new Vector(-3, 0, 0), EntanglementMagnet.ENTANGLEMENT_MAGNET, new Vector(0, 3, 0), EntanglementMagnet.ENTANGLEMENT_MAGNET, new Vector(0, -3, 0), EntanglementMagnet.ENTANGLEMENT_MAGNET, new Vector(0, 0, 3), EntanglementMagnet.ENTANGLEMENT_MAGNET, new Vector(0, 0, -3), EntanglementMagnet.ENTANGLEMENT_MAGNET);
    private final double magnetParticleAnimationLengthSeconds;

    public EntanglementContainer(ItemGroup itemGroup, SlimefunItemStack item, RecipeType recipeType, ItemStack[] recipe, Settings settings) {
        super(itemGroup, item, recipeType, recipe, settings);
        this.magnetParticleAnimationLengthSeconds = this.settings.getTimePerRecipe();
    }

    @Override
    public float getConnectionRadius() {
        return 0.0f;
    }

    @Override
    protected DisplayGroup initModel(@NotNull Location location, @NotNull Player player) {
        return new ModelBuilder().add("frame1a", new ModelLine().material(Material.CYAN_CONCRETE).from(-0.4f, -0.4f, -0.4f).to(0.4f, -0.4f, -0.4f).thickness(0.1f).extraLength(0.1f)).add("frame1b", new ModelLine().material(Material.CYAN_CONCRETE).from(-0.4f, 0.4f, -0.4f).to(0.4f, 0.4f, -0.4f).thickness(0.1f).extraLength(0.1f)).add("frame1c", new ModelLine().material(Material.CYAN_CONCRETE).from(-0.4f, -0.4f, 0.4f).to(0.4f, -0.4f, 0.4f).thickness(0.1f).extraLength(0.1f)).add("frame1d", new ModelLine().material(Material.CYAN_CONCRETE).from(-0.4f, 0.4f, 0.4f).to(0.4f, 0.4f, 0.4f).thickness(0.1f).extraLength(0.1f)).add("frame2a", new ModelLine().material(Material.CYAN_CONCRETE).from(-0.4f, -0.4f, -0.4f).to(-0.4f, 0.4f, -0.4f).thickness(0.1f)).add("frame2b", new ModelLine().material(Material.CYAN_CONCRETE).from(0.4f, -0.4f, -0.4f).to(0.4f, 0.4f, -0.4f).thickness(0.1f)).add("frame2c", new ModelLine().material(Material.CYAN_CONCRETE).from(-0.4f, -0.4f, 0.4f).to(-0.4f, 0.4f, 0.4f).thickness(0.1f)).add("frame2d", new ModelLine().material(Material.CYAN_CONCRETE).from(0.4f, -0.4f, 0.4f).to(0.4f, 0.4f, 0.4f).thickness(0.1f)).add("frame3a", new ModelLine().material(Material.CYAN_CONCRETE).from(-0.4f, -0.4f, -0.4f).to(-0.4f, -0.4f, 0.4f).thickness(0.1f)).add("frame3b", new ModelLine().material(Material.CYAN_CONCRETE).from(0.4f, -0.4f, -0.4f).to(0.4f, -0.4f, 0.4f).thickness(0.1f)).add("frame3c", new ModelLine().material(Material.CYAN_CONCRETE).from(-0.4f, 0.4f, -0.4f).to(-0.4f, 0.4f, 0.4f).thickness(0.1f)).add("frame3d", new ModelLine().material(Material.CYAN_CONCRETE).from(0.4f, 0.4f, -0.4f).to(0.4f, 0.4f, 0.4f).thickness(0.1f)).add("item", new ModelItem().brightness(15).size(0.5f)).buildAtBlockCenter(location);
    }

    @Override
    protected List<ConnectionPoint> initConnectionPoints(ConnectionGroupId groupId, Player player, Location location) {
        return new ArrayList<ConnectionPoint>();
    }

    @Override
    protected void initBlockStorage(@NotNull Location location, @NotNull Player player) {
        BlockStorageAPI.set(location, "QP_CRAFT_IN_PROGRESS", false);
        BlockStorageAPI.set(location, "QP_TIME_SINCE_CRAFT_STARTED", 0.0);
    }

    @Override
    protected boolean isTicker() {
        return true;
    }

    @Override
    protected void onBreak(@NotNull Location location) {
        super.onBreak(location);
        this.onBreakItemHolderBlock(location, "item");
    }

    @Override
    protected boolean onRightClick(@NotNull Location location, @NotNull Player player) {
        if (this.multiblockInteract(location.getBlock(), player)) {
            return true;
        }
        this.itemHolderInteract(location, "item", player);
        return true;
    }

    @Override
    public void onTick22(@NotNull ConnectionGroup group, @NotNull Location location) {
        BlockStorageAPI.set(location, "QP_MULTIBLOCK_INTACT", this.isStructureValid(location.getBlock()));
    }

    @Override
    public void onTick2(@NotNull ConnectionGroup group, @NotNull Location location) {
        if (!this.isProcessing(location)) {
            return;
        }
        if (!BlockStorageAPI.getBoolean(location, "QP_MULTIBLOCK_INTACT") || !this.allMagnetsPowered(location)) {
            this.cancelProcessing(location);
        }
        double secondsSinceCraftStarted = BlockStorageAPI.getDouble(location, "QP_TIME_SINCE_CRAFT_STARTED");
        this.tickProcessing(location, 2);
        this.tickAnimation(location, secondsSinceCraftStarted);
        if (secondsSinceCraftStarted >= this.settings.getTimePerRecipe()) {
            this.completeProcessing(location);
            EntanglementContainer.animateCenterCompleted(location);
        }
    }

    @Override
    public boolean onInsert(@NotNull Location location, @NotNull String name, @NotNull ItemStack stack, @NotNull Player player) {
        if (!this.isValidRecipe(stack)) {
            Language.sendLanguageMessage(player, "entangler.cannot-be-entangled", new Object[0]);
            return false;
        }
        if (!this.allMagnetsPowered(location)) {
            Language.sendLanguageMessage(player, "entangler.magnets-not-powered", new Object[0]);
            return false;
        }
        this.startProcessing(location);
        return true;
    }

    @Override
    public Optional<ItemStack> onRemove(@NotNull Location location, @NotNull String name, @NotNull ItemStack stack) {
        this.cancelProcessing(location);
        return Optional.of(stack);
    }

    @Override
    public Map<ItemStack, ItemStack> getRecipes() {
        return Map.of(CraftingComponents.INFUSED_MODULE_CARD, CraftingComponents.ENTANGLED_MODULE_CARD, CraftingComponents.INFUSED_FREQUENCY_CRYSTAL, CraftingComponents.ENTANGLED_FREQUENCY_CRYSTAL);
    }

    @Override
    public Map<Vector, ItemStack> getStructure() {
        return MAGNETS;
    }

    @Override
    public void tickAnimation(@NotNull Location centerLocation, double timeSeconds) {
        this.getStructure().keySet().forEach(magnetLocation -> this.animateMagnet(centerLocation, centerLocation.clone().add(magnetLocation), timeSeconds));
    }

    private static boolean isMagnetPowered(@NotNull Location pillarLocation) {
        return BlockStorageAPI.getBoolean(pillarLocation, "QP_POWERED");
    }

    private boolean allMagnetsPowered(@NotNull Location location) {
        return this.getStructure().keySet().stream().allMatch(vector -> EntanglementContainer.isMagnetPowered(location.clone().add(vector)));
    }

    private void animateMagnet(@NotNull Location center, @NotNull Location pillarLocation, double timeSinceCraftStarted) {
        Particles.animatedLine(Particle.BUBBLE_POP, pillarLocation.clone().toCenterLocation(), center.clone().toCenterLocation(), 8, 40.0 * timeSinceCraftStarted % this.magnetParticleAnimationLengthSeconds / (this.magnetParticleAnimationLengthSeconds + 0.001), 0.05);
    }

    private static void animateCenterCompleted(@NotNull Location center) {
        new ParticleBuilder(Particle.FIREWORKS_SPARK).location(center.toCenterLocation()).extra(0.1).count(50).spawn();
    }
}

