/*
 * Decompiled with CFR 0.152.
 */
package org.metamechanists.quaptics.implementation.blocks.upgraders;

import io.github.thebusybiscuit.slimefun4.api.items.ItemGroup;
import io.github.thebusybiscuit.slimefun4.api.items.SlimefunItemStack;
import io.github.thebusybiscuit.slimefun4.api.recipes.RecipeType;
import io.github.thebusybiscuit.slimefun4.utils.SlimefunUtils;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import javax.annotation.OverridingMethodsMustInvokeSuper;
import org.bukkit.Location;
import org.bukkit.Material;
import org.bukkit.entity.Player;
import org.bukkit.inventory.ItemStack;
import org.bukkit.util.Vector;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.metamechanists.quaptics.connections.ConnectionGroup;
import org.metamechanists.quaptics.connections.ConnectionPoint;
import org.metamechanists.quaptics.connections.ConnectionPointType;
import org.metamechanists.quaptics.connections.Link;
import org.metamechanists.quaptics.displaymodellib.models.ModelBuilder;
import org.metamechanists.quaptics.displaymodellib.models.components.ModelCuboid;
import org.metamechanists.quaptics.displaymodellib.models.components.ModelItem;
import org.metamechanists.quaptics.displaymodellib.sefilib.entity.display.DisplayGroup;
import org.metamechanists.quaptics.implementation.Settings;
import org.metamechanists.quaptics.implementation.attachments.ItemHolderBlock;
import org.metamechanists.quaptics.implementation.attachments.PowerAnimatedBlock;
import org.metamechanists.quaptics.implementation.attachments.PowerLossBlock;
import org.metamechanists.quaptics.implementation.base.ConnectedBlock;
import org.metamechanists.quaptics.items.Lore;
import org.metamechanists.quaptics.items.Tier;
import org.metamechanists.quaptics.items.groups.CraftingComponents;
import org.metamechanists.quaptics.utils.BlockStorageAPI;
import org.metamechanists.quaptics.utils.Language;
import org.metamechanists.quaptics.utils.id.complex.ConnectionGroupId;
import org.metamechanists.quaptics.utils.id.complex.ConnectionPointId;

public class Polariser
extends ConnectedBlock
implements PowerAnimatedBlock,
PowerLossBlock,
ItemHolderBlock {
    public static final Settings POLARISER_SETTINGS = Settings.builder().tier(Tier.INTERMEDIATE).maxPowerHidden(true).minPower(200.0).powerLoss(0.12).build();
    public static final SlimefunItemStack POLARISER = new SlimefunItemStack("QP_POLARISER", Material.YELLOW_TERRACOTTA, "&cPolariser", Lore.create(POLARISER_SETTINGS, "&7\u25cf Increases the phase of quaptic rays", "&7\u25cf The increase in phase depends on the phase crystal", "&7  that the polariser is holding", "&7\u25cf &eRight Click &7with a crystal to insert"));
    private static final Vector MAIN_INPUT_LOCATION = new Vector(0.0f, 0.0f, -0.45f);
    private static final Vector OUTPUT_LOCATION = new Vector(0.0, 0.0, 0.45);
    private static final Map<ItemStack, Integer> PHASE_CHANGES = Map.of(CraftingComponents.PHASE_CRYSTAL_1, 1, CraftingComponents.PHASE_CRYSTAL_5, 5, CraftingComponents.PHASE_CRYSTAL_15, 15, CraftingComponents.PHASE_CRYSTAL_45, 45, CraftingComponents.PHASE_CRYSTAL_90, 90, CraftingComponents.PHASE_CRYSTAL_180, 180);

    public Polariser(ItemGroup itemGroup, SlimefunItemStack item, RecipeType recipeType, ItemStack[] recipe, Settings settings) {
        super(itemGroup, item, recipeType, recipe, settings);
    }

    @Override
    public float getConnectionRadius() {
        return 0.0f;
    }

    @Override
    public void connect(@NotNull ConnectionPointId from, @NotNull ConnectionPointId to) {
    }

    @Override
    protected DisplayGroup initModel(@NotNull Location location, @NotNull Player player) {
        return new ModelBuilder().add("main", new ModelCuboid().material(Material.YELLOW_TERRACOTTA).facing(player.getFacing()).size(0.3f, 0.3f, 0.9f)).add("prism", new ModelCuboid().material(Material.GRAY_CONCRETE).brightness(3).facing(player.getFacing()).rotation(0.7853981633974483).size(0.5f)).add("item", new ModelItem().brightness(15).facing(player.getFacing()).location(0.0f, 0.3f, 0.0f).size(0.5f)).add("item2", new ModelItem().brightness(15).facing(player.getFacing()).rotation(1.5707963267948966).location(0.0f, 0.3f, 0.0f).size(0.5f)).buildAtBlockCenter(location);
    }

    @Override
    protected List<ConnectionPoint> initConnectionPoints(ConnectionGroupId groupId, Player player, Location location) {
        return List.of(new ConnectionPoint(ConnectionPointType.INPUT, groupId, "input", Polariser.formatPointLocation(player, location, MAIN_INPUT_LOCATION)), new ConnectionPoint(ConnectionPointType.OUTPUT, groupId, "output", Polariser.formatPointLocation(player, location, OUTPUT_LOCATION)));
    }

    @Override
    public void onInputLinkUpdated(@NotNull ConnectionGroup group, @NotNull Location location) {
        if (!BlockStorageAPI.getBoolean(location, "QP_IS_HOLDING_ITEM")) {
            this.onPoweredAnimation(location, false);
            return;
        }
        Optional<ItemStack> itemStack = ItemHolderBlock.getStack(location, "item");
        if (itemStack.isEmpty()) {
            return;
        }
        this.updateOutput(location, itemStack.get());
    }

    @Override
    public void onPoweredAnimation(@NotNull Location location, boolean powered) {
        this.brightnessAnimation(location, "prism", powered);
    }

    @Override
    @OverridingMethodsMustInvokeSuper
    protected void onBreak(@NotNull Location location) {
        super.onBreak(location);
        this.onBreakItemHolderBlock(location, "item");
    }

    @Override
    protected boolean onRightClick(@NotNull Location location, @NotNull Player player) {
        this.itemHolderInteract(location, "item", player);
        return true;
    }

    @Override
    public boolean onInsert(@NotNull Location location, @NotNull String name, @NotNull ItemStack stack, @NotNull Player player) {
        Optional<Integer> phaseChange = Polariser.getPhaseChange(stack);
        if (phaseChange.isEmpty()) {
            Language.sendLanguageMessage(player, "polariser.not-phase-crystal", new Object[0]);
            return false;
        }
        Polariser.getItemDisplay(location, "item2").ifPresent(display -> display.setItemStack(stack.clone()));
        this.updateOutput(location, stack);
        return true;
    }

    @Override
    public Optional<ItemStack> onRemove(@NotNull Location location, @NotNull String name, @NotNull ItemStack stack) {
        Polariser.getItemDisplay(location, "item2").ifPresent(display -> display.setItemStack(new ItemStack(Material.AIR)));
        this.updateOutput(location, null);
        return Optional.of(stack);
    }

    private void updateOutput(@NotNull Location location, @Nullable ItemStack itemStack) {
        Optional<Link> inputLink = Polariser.getLink(location, "input");
        Optional<Link> outputLink = Polariser.getLink(location, "output");
        boolean powered = inputLink.isPresent() && this.settings.isOperational(inputLink) && itemStack != null;
        this.onPoweredAnimation(location, powered);
        if (outputLink.isEmpty()) {
            return;
        }
        if (!powered) {
            outputLink.ifPresent(Link::disable);
            return;
        }
        Optional<Integer> phaseChange = Polariser.getPhaseChange(itemStack);
        if (phaseChange.isEmpty()) {
            return;
        }
        outputLink.get().setPowerFrequencyPhase(PowerLossBlock.calculatePowerLoss(this.settings, inputLink.get()), inputLink.get().getFrequency(), inputLink.get().getPhase() + phaseChange.get());
    }

    private static Optional<Integer> getPhaseChange(@NotNull ItemStack itemStack) {
        for (Map.Entry<ItemStack, Integer> entry : PHASE_CHANGES.entrySet()) {
            if (!SlimefunUtils.isItemSimilar((ItemStack)entry.getKey(), (ItemStack)itemStack, (boolean)true)) continue;
            return Optional.ofNullable(entry.getValue());
        }
        return Optional.empty();
    }
}

