/*
 * Decompiled with CFR 0.152.
 */
package org.metamechanists.quaptics.implementation.blocks.upgraders;

import io.github.thebusybiscuit.slimefun4.api.items.ItemGroup;
import io.github.thebusybiscuit.slimefun4.api.items.SlimefunItemStack;
import io.github.thebusybiscuit.slimefun4.api.recipes.RecipeType;
import java.util.List;
import java.util.Optional;
import org.bukkit.Location;
import org.bukkit.Material;
import org.bukkit.entity.Player;
import org.bukkit.inventory.ItemStack;
import org.bukkit.util.Vector;
import org.jetbrains.annotations.NotNull;
import org.metamechanists.quaptics.connections.ConnectionGroup;
import org.metamechanists.quaptics.connections.ConnectionPoint;
import org.metamechanists.quaptics.connections.ConnectionPointType;
import org.metamechanists.quaptics.connections.Link;
import org.metamechanists.quaptics.displaymodellib.models.ModelBuilder;
import org.metamechanists.quaptics.displaymodellib.models.components.ModelCuboid;
import org.metamechanists.quaptics.displaymodellib.sefilib.entity.display.DisplayGroup;
import org.metamechanists.quaptics.implementation.Settings;
import org.metamechanists.quaptics.implementation.attachments.PowerAnimatedBlock;
import org.metamechanists.quaptics.implementation.attachments.PowerLossBlock;
import org.metamechanists.quaptics.implementation.base.ConnectedBlock;
import org.metamechanists.quaptics.items.Lore;
import org.metamechanists.quaptics.items.Tier;
import org.metamechanists.quaptics.utils.id.complex.ConnectionGroupId;
import org.metamechanists.quaptics.utils.id.complex.ConnectionPointId;

public class Interferometer
extends ConnectedBlock
implements PowerAnimatedBlock,
PowerLossBlock {
    public static final Settings INTERFEROMETER_SETTINGS = Settings.builder().tier(Tier.INTERMEDIATE).maxPowerHidden(true).minPower(650.0).powerLoss(0.08).build();
    public static final SlimefunItemStack INTERFEROMETER = new SlimefunItemStack("QP_INTERFEROMETER", Material.YELLOW_TERRACOTTA, "&cInterferometer", Lore.create(INTERFEROMETER_SETTINGS, "&7\u25cf Sets the phase of the main ray to the phase of the auxiliary ray", "&7\u25cf The operating power only applies to the main beam"));
    private static final Vector MAIN_INPUT_LOCATION = new Vector(0.0, 0.0, -0.45);
    private static final Vector AUXILIARY_INPUT_LOCATION = new Vector(0.4, 0.0, 0.0);
    private static final Vector OUTPUT_LOCATION = new Vector(0.0, 0.0, 0.45);

    public Interferometer(ItemGroup itemGroup, SlimefunItemStack item, RecipeType recipeType, ItemStack[] recipe, Settings settings) {
        super(itemGroup, item, recipeType, recipe, settings);
    }

    @Override
    public float getConnectionRadius() {
        return 0.0f;
    }

    @Override
    public void connect(@NotNull ConnectionPointId from, @NotNull ConnectionPointId to) {
    }

    @Override
    protected DisplayGroup initModel(@NotNull Location location, @NotNull Player player) {
        return new ModelBuilder().add("main", new ModelCuboid().material(Material.YELLOW_TERRACOTTA).facing(player.getFacing()).size(0.3f, 0.3f, 0.9f)).add("auxiliary", new ModelCuboid().material(Material.GRAY_CONCRETE).facing(player.getFacing()).size(0.4f, 0.15f, 0.15f).location(0.2f, 0.0f, 0.0f)).add("prism", new ModelCuboid().material(Material.GRAY_CONCRETE).brightness(3).facing(player.getFacing()).rotation(0.7853981633974483).size(0.4f)).buildAtBlockCenter(location);
    }

    @Override
    protected List<ConnectionPoint> initConnectionPoints(ConnectionGroupId groupId, Player player, Location location) {
        return List.of(new ConnectionPoint(ConnectionPointType.INPUT, groupId, "main", Interferometer.formatPointLocation(player, location, MAIN_INPUT_LOCATION)), new ConnectionPoint(ConnectionPointType.INPUT, groupId, "auxiliary", Interferometer.formatPointLocation(player, location, AUXILIARY_INPUT_LOCATION)), new ConnectionPoint(ConnectionPointType.OUTPUT, groupId, "output", Interferometer.formatPointLocation(player, location, OUTPUT_LOCATION)));
    }

    @Override
    public void onInputLinkUpdated(@NotNull ConnectionGroup group, @NotNull Location location) {
        Optional<Link> mainLink = Interferometer.getLink(location, "main");
        Optional<Link> auxiliaryLink = Interferometer.getLink(location, "auxiliary");
        Optional<Link> outputLink = Interferometer.getLink(location, "output");
        this.onPoweredAnimation(location, this.settings.isOperational(mainLink));
        if (outputLink.isEmpty()) {
            return;
        }
        if (auxiliaryLink.isEmpty() || mainLink.isEmpty() || !this.settings.isOperational(mainLink)) {
            outputLink.get().disable();
            return;
        }
        outputLink.get().setPowerFrequencyPhase(PowerLossBlock.calculatePowerLoss(this.settings, mainLink.get()), mainLink.get().getFrequency(), auxiliaryLink.get().getPhase());
    }

    @Override
    public void onPoweredAnimation(@NotNull Location location, boolean powered) {
        this.brightnessAnimation(location, "prism", powered);
    }
}

