/*
 * Decompiled with CFR 0.152.
 */
package org.metamechanists.quaptics.implementation.blocks.manipulators;

import io.github.thebusybiscuit.slimefun4.api.items.ItemGroup;
import io.github.thebusybiscuit.slimefun4.api.items.SlimefunItemStack;
import io.github.thebusybiscuit.slimefun4.api.recipes.RecipeType;
import java.util.ArrayList;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.stream.IntStream;
import org.bukkit.Location;
import org.bukkit.Material;
import org.bukkit.entity.Player;
import org.bukkit.inventory.ItemStack;
import org.bukkit.util.Vector;
import org.jetbrains.annotations.NotNull;
import org.metamechanists.quaptics.connections.ConnectionGroup;
import org.metamechanists.quaptics.connections.ConnectionPoint;
import org.metamechanists.quaptics.connections.ConnectionPointType;
import org.metamechanists.quaptics.connections.Link;
import org.metamechanists.quaptics.displaymodellib.models.ModelBuilder;
import org.metamechanists.quaptics.displaymodellib.models.components.ModelDiamond;
import org.metamechanists.quaptics.displaymodellib.sefilib.entity.display.DisplayGroup;
import org.metamechanists.quaptics.implementation.Settings;
import org.metamechanists.quaptics.implementation.attachments.PowerAnimatedBlock;
import org.metamechanists.quaptics.implementation.attachments.PowerLossBlock;
import org.metamechanists.quaptics.implementation.base.ConnectedBlock;
import org.metamechanists.quaptics.items.Lore;
import org.metamechanists.quaptics.items.Tier;
import org.metamechanists.quaptics.utils.id.complex.ConnectionGroupId;

public class Splitter
extends ConnectedBlock
implements PowerAnimatedBlock,
PowerLossBlock {
    public static final Settings SPLITTER_1_SETTINGS = Settings.builder().tier(Tier.PRIMITIVE).powerLoss(0.2).connections(2).build();
    public static final Settings SPLITTER_2_SETTINGS = Settings.builder().tier(Tier.BASIC).powerLoss(0.14).connections(3).build();
    public static final Settings SPLITTER_3_SETTINGS = Settings.builder().tier(Tier.INTERMEDIATE).powerLoss(0.08).connections(4).build();
    public static final Settings SPLITTER_4_SETTINGS = Settings.builder().tier(Tier.ADVANCED).powerLoss(0.05).connections(5).build();
    public static final SlimefunItemStack SPLITTER_1 = new SlimefunItemStack("QP_SPLITTER_1", Material.LIGHT_GRAY_STAINED_GLASS, "&9Splitter &8I", Lore.create(SPLITTER_1_SETTINGS, "&7\u25cf Splits one quaptic ray into multiple"));
    public static final SlimefunItemStack SPLITTER_2 = new SlimefunItemStack("QP_SPLITTER_2", Material.LIGHT_GRAY_STAINED_GLASS, "&9Splitter &8II", Lore.create(SPLITTER_2_SETTINGS, "&7\u25cf Splits one quaptic ray into multiple"));
    public static final SlimefunItemStack SPLITTER_3 = new SlimefunItemStack("QP_SPLITTER_3", Material.LIGHT_GRAY_STAINED_GLASS, "&9Splitter &8III", Lore.create(SPLITTER_3_SETTINGS, "&7\u25cf Splits one quaptic ray into multiple"));
    public static final SlimefunItemStack SPLITTER_4 = new SlimefunItemStack("QP_SPLITTER_4", Material.LIGHT_GRAY_STAINED_GLASS, "&9Splitter &8IV", Lore.create(SPLITTER_4_SETTINGS, "&7\u25cf Splits one quaptic ray into multiple"));
    private static final double CONNECTION_ANGLE = 2.0943951023931953;
    private final Vector inputLocation = new Vector(0.0f, 0.0f, -this.getConnectionRadius());
    private final Vector outputStartingLocation = new Vector(0.0f, 0.0f, this.getConnectionRadius());

    public Splitter(ItemGroup itemGroup, SlimefunItemStack item, RecipeType recipeType, ItemStack[] recipe, Settings settings) {
        super(itemGroup, item, recipeType, recipe, settings);
    }

    @Override
    public float getConnectionRadius() {
        return 0.55f;
    }

    @Override
    protected DisplayGroup initModel(@NotNull Location location, @NotNull Player player) {
        return new ModelBuilder().add("concrete", new ModelDiamond().material(this.settings.getTier().concreteMaterial).brightness(3).size(0.4f)).add("glass", new ModelDiamond().material(Material.LIGHT_GRAY_STAINED_GLASS).size(0.8f)).buildAtBlockCenter(location);
    }

    @Override
    protected List<ConnectionPoint> initConnectionPoints(ConnectionGroupId groupId, Player player, Location location) {
        ArrayList<ConnectionPoint> points = new ArrayList<ConnectionPoint>();
        points.add(new ConnectionPoint(ConnectionPointType.INPUT, groupId, "input", Splitter.formatPointLocation(player, location, this.inputLocation)));
        IntStream.range(0, this.settings.getConnections()).forEach(i -> points.add(new ConnectionPoint(ConnectionPointType.OUTPUT, groupId, "output " + Objects.toString(i), Splitter.formatPointLocation(player, location, this.getRelativeOutputLocation(i)))));
        return points;
    }

    @Override
    public void onInputLinkUpdated(@NotNull ConnectionGroup group, @NotNull Location location) {
        if (this.doBurnoutCheck(group, "input")) {
            return;
        }
        List<Link> outgoingLinks = Splitter.getOutgoingLinks(location);
        if (outgoingLinks.isEmpty()) {
            return;
        }
        Optional<Link> inputLink = Splitter.getLink(location, "input");
        if (inputLink.isEmpty()) {
            outgoingLinks.forEach(Link::disable);
            return;
        }
        this.onPoweredAnimation(location, inputLink.get().isEnabled());
        double outputPower = PowerLossBlock.calculatePowerLoss(this.settings, inputLink.get().getPower()) / (double)outgoingLinks.size();
        double outputFrequency = inputLink.get().getFrequency();
        int outputPhase = inputLink.get().getPhase();
        outgoingLinks.forEach(output -> output.setPowerFrequencyPhase(outputPower, outputFrequency, outputPhase));
    }

    @Override
    public void onPoweredAnimation(@NotNull Location location, boolean powered) {
        this.brightnessAnimation(location, "concrete", powered);
    }

    @NotNull
    private Vector getRelativeOutputLocation(int i) {
        double angle = -1.0471975511965976 + 2.0943951023931953 * ((double)i / (double)(this.settings.getConnections() - 1));
        return this.outputStartingLocation.clone().rotateAroundY(angle);
    }
}

