/*
 * Decompiled with CFR 0.152.
 */
package org.metamechanists.quaptics.implementation;

import java.util.Optional;
import java.util.Set;
import org.bukkit.Material;
import org.bukkit.entity.SpawnCategory;
import org.jetbrains.annotations.NotNull;
import org.metamechanists.quaptics.connections.Link;
import org.metamechanists.quaptics.items.Tier;

public class Settings {
    private Tier tier;
    private boolean operatingPowerHidden;
    private boolean maxPowerHidden;
    private float rotationY;
    private String comparatorVisual;
    private int repeaterDelay;
    private int energyCapacity;
    private int energyConsumption;
    private double minPower;
    private double powerLoss;
    private double chargeCapacity;
    private double outputPower;
    private double maxOutputPower;
    private double powerThreshold;
    private double powerMultiplier;
    private double chargePerShot;
    private double minFrequency;
    private double maxFrequency;
    private double frequencyStep;
    private double frequencyMultiplier;
    private int targetPhase;
    private int targetPhaseSpread;
    private int connections;
    private double useInterval;
    private double timePerRecipe;
    private int timeToMaxEfficiency;
    private float projectileSpeed;
    private int range;
    private double damage;
    private int luckLevel;
    private int fireResistanceLevel;
    private double experienceMultiplier;
    private double powerEfficiency;
    private Set<SpawnCategory> targets;
    Material projectileMaterial;
    Material mainMaterial;

    public boolean isOperational(@NotNull Link inputLink) {
        return inputLink.isEnabled() && inputLink.getPower() >= this.minPower && inputLink.getFrequency() >= this.minFrequency && (this.maxFrequency == 0.0 || inputLink.getFrequency() <= this.maxFrequency);
    }

    public boolean isOperational(@NotNull Optional<? extends Link> inputLink) {
        return inputLink.isPresent() && this.isOperational(inputLink.get());
    }

    Settings(Tier tier, boolean operatingPowerHidden, boolean maxPowerHidden, float rotationY, String comparatorVisual, int repeaterDelay, int energyCapacity, int energyConsumption, double minPower, double powerLoss, double chargeCapacity, double outputPower, double maxOutputPower, double powerThreshold, double powerMultiplier, double chargePerShot, double minFrequency, double maxFrequency, double frequencyStep, double frequencyMultiplier, int targetPhase, int targetPhaseSpread, int connections, double useInterval, double timePerRecipe, int timeToMaxEfficiency, float projectileSpeed, int range, double damage, int luckLevel, int fireResistanceLevel, double experienceMultiplier, double powerEfficiency, Set<SpawnCategory> targets, Material projectileMaterial, Material mainMaterial) {
        this.tier = tier;
        this.operatingPowerHidden = operatingPowerHidden;
        this.maxPowerHidden = maxPowerHidden;
        this.rotationY = rotationY;
        this.comparatorVisual = comparatorVisual;
        this.repeaterDelay = repeaterDelay;
        this.energyCapacity = energyCapacity;
        this.energyConsumption = energyConsumption;
        this.minPower = minPower;
        this.powerLoss = powerLoss;
        this.chargeCapacity = chargeCapacity;
        this.outputPower = outputPower;
        this.maxOutputPower = maxOutputPower;
        this.powerThreshold = powerThreshold;
        this.powerMultiplier = powerMultiplier;
        this.chargePerShot = chargePerShot;
        this.minFrequency = minFrequency;
        this.maxFrequency = maxFrequency;
        this.frequencyStep = frequencyStep;
        this.frequencyMultiplier = frequencyMultiplier;
        this.targetPhase = targetPhase;
        this.targetPhaseSpread = targetPhaseSpread;
        this.connections = connections;
        this.useInterval = useInterval;
        this.timePerRecipe = timePerRecipe;
        this.timeToMaxEfficiency = timeToMaxEfficiency;
        this.projectileSpeed = projectileSpeed;
        this.range = range;
        this.damage = damage;
        this.luckLevel = luckLevel;
        this.fireResistanceLevel = fireResistanceLevel;
        this.experienceMultiplier = experienceMultiplier;
        this.powerEfficiency = powerEfficiency;
        this.targets = targets;
        this.projectileMaterial = projectileMaterial;
        this.mainMaterial = mainMaterial;
    }

    public static SettingsBuilder builder() {
        return new SettingsBuilder();
    }

    public Tier getTier() {
        return this.tier;
    }

    public boolean isOperatingPowerHidden() {
        return this.operatingPowerHidden;
    }

    public boolean isMaxPowerHidden() {
        return this.maxPowerHidden;
    }

    public float getRotationY() {
        return this.rotationY;
    }

    public String getComparatorVisual() {
        return this.comparatorVisual;
    }

    public int getRepeaterDelay() {
        return this.repeaterDelay;
    }

    public int getEnergyCapacity() {
        return this.energyCapacity;
    }

    public int getEnergyConsumption() {
        return this.energyConsumption;
    }

    public double getMinPower() {
        return this.minPower;
    }

    public double getPowerLoss() {
        return this.powerLoss;
    }

    public double getChargeCapacity() {
        return this.chargeCapacity;
    }

    public double getOutputPower() {
        return this.outputPower;
    }

    public double getMaxOutputPower() {
        return this.maxOutputPower;
    }

    public double getPowerThreshold() {
        return this.powerThreshold;
    }

    public double getPowerMultiplier() {
        return this.powerMultiplier;
    }

    public double getChargePerShot() {
        return this.chargePerShot;
    }

    public double getMinFrequency() {
        return this.minFrequency;
    }

    public double getMaxFrequency() {
        return this.maxFrequency;
    }

    public double getFrequencyStep() {
        return this.frequencyStep;
    }

    public double getFrequencyMultiplier() {
        return this.frequencyMultiplier;
    }

    public int getTargetPhase() {
        return this.targetPhase;
    }

    public int getTargetPhaseSpread() {
        return this.targetPhaseSpread;
    }

    public int getConnections() {
        return this.connections;
    }

    public double getUseInterval() {
        return this.useInterval;
    }

    public double getTimePerRecipe() {
        return this.timePerRecipe;
    }

    public int getTimeToMaxEfficiency() {
        return this.timeToMaxEfficiency;
    }

    public float getProjectileSpeed() {
        return this.projectileSpeed;
    }

    public int getRange() {
        return this.range;
    }

    public double getDamage() {
        return this.damage;
    }

    public int getLuckLevel() {
        return this.luckLevel;
    }

    public int getFireResistanceLevel() {
        return this.fireResistanceLevel;
    }

    public double getExperienceMultiplier() {
        return this.experienceMultiplier;
    }

    public double getPowerEfficiency() {
        return this.powerEfficiency;
    }

    public Set<SpawnCategory> getTargets() {
        return this.targets;
    }

    public Material getProjectileMaterial() {
        return this.projectileMaterial;
    }

    public Material getMainMaterial() {
        return this.mainMaterial;
    }

    public static class SettingsBuilder {
        private Tier tier;
        private boolean operatingPowerHidden;
        private boolean maxPowerHidden;
        private float rotationY;
        private String comparatorVisual;
        private int repeaterDelay;
        private int energyCapacity;
        private int energyConsumption;
        private double minPower;
        private double powerLoss;
        private double chargeCapacity;
        private double outputPower;
        private double maxOutputPower;
        private double powerThreshold;
        private double powerMultiplier;
        private double chargePerShot;
        private double minFrequency;
        private double maxFrequency;
        private double frequencyStep;
        private double frequencyMultiplier;
        private int targetPhase;
        private int targetPhaseSpread;
        private int connections;
        private double useInterval;
        private double timePerRecipe;
        private int timeToMaxEfficiency;
        private float projectileSpeed;
        private int range;
        private double damage;
        private int luckLevel;
        private int fireResistanceLevel;
        private double experienceMultiplier;
        private double powerEfficiency;
        private Set<SpawnCategory> targets;
        private Material projectileMaterial;
        private Material mainMaterial;

        SettingsBuilder() {
        }

        public SettingsBuilder tier(Tier tier) {
            this.tier = tier;
            return this;
        }

        public SettingsBuilder operatingPowerHidden(boolean operatingPowerHidden) {
            this.operatingPowerHidden = operatingPowerHidden;
            return this;
        }

        public SettingsBuilder maxPowerHidden(boolean maxPowerHidden) {
            this.maxPowerHidden = maxPowerHidden;
            return this;
        }

        public SettingsBuilder rotationY(float rotationY) {
            this.rotationY = rotationY;
            return this;
        }

        public SettingsBuilder comparatorVisual(String comparatorVisual) {
            this.comparatorVisual = comparatorVisual;
            return this;
        }

        public SettingsBuilder repeaterDelay(int repeaterDelay) {
            this.repeaterDelay = repeaterDelay;
            return this;
        }

        public SettingsBuilder energyCapacity(int energyCapacity) {
            this.energyCapacity = energyCapacity;
            return this;
        }

        public SettingsBuilder energyConsumption(int energyConsumption) {
            this.energyConsumption = energyConsumption;
            return this;
        }

        public SettingsBuilder minPower(double minPower) {
            this.minPower = minPower;
            return this;
        }

        public SettingsBuilder powerLoss(double powerLoss) {
            this.powerLoss = powerLoss;
            return this;
        }

        public SettingsBuilder chargeCapacity(double chargeCapacity) {
            this.chargeCapacity = chargeCapacity;
            return this;
        }

        public SettingsBuilder outputPower(double outputPower) {
            this.outputPower = outputPower;
            return this;
        }

        public SettingsBuilder maxOutputPower(double maxOutputPower) {
            this.maxOutputPower = maxOutputPower;
            return this;
        }

        public SettingsBuilder powerThreshold(double powerThreshold) {
            this.powerThreshold = powerThreshold;
            return this;
        }

        public SettingsBuilder powerMultiplier(double powerMultiplier) {
            this.powerMultiplier = powerMultiplier;
            return this;
        }

        public SettingsBuilder chargePerShot(double chargePerShot) {
            this.chargePerShot = chargePerShot;
            return this;
        }

        public SettingsBuilder minFrequency(double minFrequency) {
            this.minFrequency = minFrequency;
            return this;
        }

        public SettingsBuilder maxFrequency(double maxFrequency) {
            this.maxFrequency = maxFrequency;
            return this;
        }

        public SettingsBuilder frequencyStep(double frequencyStep) {
            this.frequencyStep = frequencyStep;
            return this;
        }

        public SettingsBuilder frequencyMultiplier(double frequencyMultiplier) {
            this.frequencyMultiplier = frequencyMultiplier;
            return this;
        }

        public SettingsBuilder targetPhase(int targetPhase) {
            this.targetPhase = targetPhase;
            return this;
        }

        public SettingsBuilder targetPhaseSpread(int targetPhaseSpread) {
            this.targetPhaseSpread = targetPhaseSpread;
            return this;
        }

        public SettingsBuilder connections(int connections) {
            this.connections = connections;
            return this;
        }

        public SettingsBuilder useInterval(double useInterval) {
            this.useInterval = useInterval;
            return this;
        }

        public SettingsBuilder timePerRecipe(double timePerRecipe) {
            this.timePerRecipe = timePerRecipe;
            return this;
        }

        public SettingsBuilder timeToMaxEfficiency(int timeToMaxEfficiency) {
            this.timeToMaxEfficiency = timeToMaxEfficiency;
            return this;
        }

        public SettingsBuilder projectileSpeed(float projectileSpeed) {
            this.projectileSpeed = projectileSpeed;
            return this;
        }

        public SettingsBuilder range(int range) {
            this.range = range;
            return this;
        }

        public SettingsBuilder damage(double damage) {
            this.damage = damage;
            return this;
        }

        public SettingsBuilder luckLevel(int luckLevel) {
            this.luckLevel = luckLevel;
            return this;
        }

        public SettingsBuilder fireResistanceLevel(int fireResistanceLevel) {
            this.fireResistanceLevel = fireResistanceLevel;
            return this;
        }

        public SettingsBuilder experienceMultiplier(double experienceMultiplier) {
            this.experienceMultiplier = experienceMultiplier;
            return this;
        }

        public SettingsBuilder powerEfficiency(double powerEfficiency) {
            this.powerEfficiency = powerEfficiency;
            return this;
        }

        public SettingsBuilder targets(Set<SpawnCategory> targets) {
            this.targets = targets;
            return this;
        }

        public SettingsBuilder projectileMaterial(Material projectileMaterial) {
            this.projectileMaterial = projectileMaterial;
            return this;
        }

        public SettingsBuilder mainMaterial(Material mainMaterial) {
            this.mainMaterial = mainMaterial;
            return this;
        }

        public Settings build() {
            return new Settings(this.tier, this.operatingPowerHidden, this.maxPowerHidden, this.rotationY, this.comparatorVisual, this.repeaterDelay, this.energyCapacity, this.energyConsumption, this.minPower, this.powerLoss, this.chargeCapacity, this.outputPower, this.maxOutputPower, this.powerThreshold, this.powerMultiplier, this.chargePerShot, this.minFrequency, this.maxFrequency, this.frequencyStep, this.frequencyMultiplier, this.targetPhase, this.targetPhaseSpread, this.connections, this.useInterval, this.timePerRecipe, this.timeToMaxEfficiency, this.projectileSpeed, this.range, this.damage, this.luckLevel, this.fireResistanceLevel, this.experienceMultiplier, this.powerEfficiency, this.targets, this.projectileMaterial, this.mainMaterial);
        }

        public String toString() {
            return "Settings.SettingsBuilder(tier=" + this.tier + ", operatingPowerHidden=" + this.operatingPowerHidden + ", maxPowerHidden=" + this.maxPowerHidden + ", rotationY=" + this.rotationY + ", comparatorVisual=" + this.comparatorVisual + ", repeaterDelay=" + this.repeaterDelay + ", energyCapacity=" + this.energyCapacity + ", energyConsumption=" + this.energyConsumption + ", minPower=" + this.minPower + ", powerLoss=" + this.powerLoss + ", chargeCapacity=" + this.chargeCapacity + ", outputPower=" + this.outputPower + ", maxOutputPower=" + this.maxOutputPower + ", powerThreshold=" + this.powerThreshold + ", powerMultiplier=" + this.powerMultiplier + ", chargePerShot=" + this.chargePerShot + ", minFrequency=" + this.minFrequency + ", maxFrequency=" + this.maxFrequency + ", frequencyStep=" + this.frequencyStep + ", frequencyMultiplier=" + this.frequencyMultiplier + ", targetPhase=" + this.targetPhase + ", targetPhaseSpread=" + this.targetPhaseSpread + ", connections=" + this.connections + ", useInterval=" + this.useInterval + ", timePerRecipe=" + this.timePerRecipe + ", timeToMaxEfficiency=" + this.timeToMaxEfficiency + ", projectileSpeed=" + this.projectileSpeed + ", range=" + this.range + ", damage=" + this.damage + ", luckLevel=" + this.luckLevel + ", fireResistanceLevel=" + this.fireResistanceLevel + ", experienceMultiplier=" + this.experienceMultiplier + ", powerEfficiency=" + this.powerEfficiency + ", targets=" + this.targets + ", projectileMaterial=" + this.projectileMaterial + ", mainMaterial=" + this.mainMaterial + ")";
        }
    }
}

