/*
 * Decompiled with CFR 0.152.
 */
package org.metamechanists.quaptics.storage;

import java.util.Optional;
import org.bukkit.scheduler.BukkitRunnable;
import org.metamechanists.quaptics.beams.DeprecatedBeamStorage;
import org.metamechanists.quaptics.connections.ConnectionGroup;
import org.metamechanists.quaptics.implementation.multiblocks.beacons.modules.player.ExperienceModuleListener;
import org.metamechanists.quaptics.schedulers.BlockUpdateScheduler;
import org.metamechanists.quaptics.schedulers.PointPanelUpdateScheduler;
import org.metamechanists.quaptics.storage.QuapticStorage;
import org.metamechanists.quaptics.utils.id.complex.ConnectionGroupId;

public class QuapticTicker
extends BukkitRunnable {
    private static long time;
    public static final int TICKS_PER_SECOND = 20;
    public static final int INTERVAL_TICKS = 2;
    public static final int INTERVAL_TICKS_2 = 2;
    public static final int INTERVAL_TICKS_6 = 6;
    public static final int INTERVAL_TICKS_10 = 10;
    public static final int INTERVAL_TICKS_22 = 22;
    public static final int INTERVAL_TICKS_102 = 102;

    public void run() {
        if ((time += 2L) % 22L == 0L) {
            ExperienceModuleListener.clearCache();
        }
        for (ConnectionGroupId groupId : QuapticStorage.getTickingGroupIds()) {
            if (((Optional)groupId.get()).isEmpty()) continue;
            ConnectionGroup group = (ConnectionGroup)((Optional)groupId.get()).get();
            try {
                group.tick2();
                if (time % 6L == 0L) {
                    group.tick6();
                }
                if (time % 22L == 0L) {
                    group.tick22();
                }
                if (time % 102L != 0L) continue;
                group.tick102();
            }
            catch (RuntimeException exception) {
                QuapticStorage.removeGroup(group.getId());
                exception.printStackTrace();
            }
        }
        DeprecatedBeamStorage.tick();
        BlockUpdateScheduler.tick();
        PointPanelUpdateScheduler.tick();
    }
}

