/*
 * Decompiled with CFR 0.152.
 */
package org.metamechanists.quaptics.panels.info.implementation;

import java.util.Optional;
import org.bukkit.Location;
import org.bukkit.util.Vector;
import org.jetbrains.annotations.NotNull;
import org.metamechanists.quaptics.connections.ConnectionPoint;
import org.metamechanists.quaptics.connections.Link;
import org.metamechanists.quaptics.items.Lore;
import org.metamechanists.quaptics.panels.info.InfoPanel;
import org.metamechanists.quaptics.panels.info.InfoPanelBuilder;
import org.metamechanists.quaptics.panels.info.InfoPanelContainer;
import org.metamechanists.quaptics.utils.id.complex.ConnectionPointId;
import org.metamechanists.quaptics.utils.id.complex.InfoPanelId;

public class PointInfoPanel
extends InfoPanel {
    private static final float SIZE = 0.25f;
    private final ConnectionPointId pointId;

    public PointInfoPanel(@NotNull Location location, ConnectionPointId pointId) {
        super(location);
        this.pointId = pointId;
    }

    public PointInfoPanel(@NotNull InfoPanelId panelId, ConnectionPointId pointId) {
        super(panelId);
        this.pointId = pointId;
    }

    private Optional<ConnectionPoint> getPoint() {
        return this.pointId.get();
    }

    @Override
    protected Vector getOffset() {
        return new Vector(0.0, 0.4, 0.0);
    }

    @Override
    protected InfoPanelContainer buildPanelContainer(@NotNull Location location) {
        return new InfoPanelBuilder(location.clone().add(this.getOffset()), 0.25f).addAttribute("name", false).addAttribute("power", true).addAttribute("frequency", true).addAttribute("phase", true).build();
    }

    @Override
    public void update() {
        if (this.isPanelHidden()) {
            return;
        }
        if (this.getPoint().isEmpty()) {
            this.remove();
            return;
        }
        ConnectionPoint point = this.getPoint().get();
        this.container.setText("name", (point.getLink().isPresent() ? "&a" : "&c") + point.getName().toUpperCase());
        if (point.getLink().isEmpty()) {
            this.container.setAttributeHidden("power", true);
            this.container.setAttributeHidden("frequency", true);
            this.container.setAttributeHidden("phase", true);
            return;
        }
        Link link = point.getLink().get();
        this.container.setAttributeHidden("power", link.getPower() == 0.0);
        this.container.setAttributeHidden("frequency", link.getFrequency() == 0.0);
        this.container.setAttributeHidden("phase", link.getPhase() == 0);
        this.container.setText("power", Lore.powerInfoPanel(link.getPower()));
        this.container.setText("frequency", Lore.frequencyInfoPanel(link.getFrequency()));
        this.container.setText("phase", Lore.phaseInfoPanel(link.getPhase()));
    }
}

