/*
 * Decompiled with CFR 0.152.
 */
package org.metamechanists.quaptics.panels.config.implementation;

import java.util.Objects;
import java.util.Optional;
import org.bukkit.Location;
import org.bukkit.entity.Player;
import org.bukkit.util.Vector;
import org.jetbrains.annotations.NotNull;
import org.metamechanists.quaptics.connections.ConnectionGroup;
import org.metamechanists.quaptics.implementation.blocks.concentrators.CreativeConcentrator;
import org.metamechanists.quaptics.items.Lore;
import org.metamechanists.quaptics.panels.config.ConfigPanel;
import org.metamechanists.quaptics.panels.config.ConfigPanelBuilder;
import org.metamechanists.quaptics.panels.config.ConfigPanelContainer;
import org.metamechanists.quaptics.utils.BlockStorageAPI;
import org.metamechanists.quaptics.utils.Utils;
import org.metamechanists.quaptics.utils.id.complex.ConfigPanelId;
import org.metamechanists.quaptics.utils.id.complex.ConnectionGroupId;

public class CreativeConcentratorConfigPanel
extends ConfigPanel {
    public CreativeConcentratorConfigPanel(@NotNull Location location, ConnectionGroupId groupId, float rotationY) {
        super(groupId, location, rotationY);
    }

    public CreativeConcentratorConfigPanel(@NotNull ConfigPanelId id, ConnectionGroupId groupId) {
        super(id, groupId);
    }

    @Override
    protected ConfigPanelContainer buildPanelContainer(@NotNull ConnectionGroupId groupId, @NotNull Location location, float rotationY) {
        return new ConfigPanelBuilder(groupId, location.clone().add(this.getOffset()), 0.3f, rotationY).addAttribute("points", Lore.COUNT_SYMBOL + "&fPoints").addAttribute("phase", Lore.PHASE_SYMBOL + "&fPhase").addAttribute("frequency", Lore.FREQUENCY_SYMBOL + "&fFrequency").addAttribute("power", Lore.POWER_SYMBOL + "&fPower").build();
    }

    @Override
    public void interact(@NotNull Player player, @NotNull Location location, String name, String type) {
        if ("power".equals(name)) {
            double power = BlockStorageAPI.getDouble(location, "QP_OUTPUT_POWER");
            power += (double)(("add".equals(type) ? 1 : -1) * (player.isSneaking() ? 100 : 1));
            power = Utils.clampToRange(power, 0.0, Double.MAX_VALUE);
            BlockStorageAPI.set(location, "QP_OUTPUT_POWER", power);
        }
        if ("frequency".equals(name)) {
            double frequency = BlockStorageAPI.getDouble(location, "QP_OUTPUT_FREQUENCY");
            frequency += (double)(("add".equals(type) ? 1 : -1) * (player.isSneaking() ? 100 : 1));
            frequency = Utils.clampToRange(frequency, 0.0, Double.MAX_VALUE);
            BlockStorageAPI.set(location, "QP_OUTPUT_FREQUENCY", frequency);
        }
        if ("phase".equals(name)) {
            int phase = BlockStorageAPI.getInt(location, "QP_OUTPUT_PHASE");
            phase += ("add".equals(type) ? 1 : -1) * (player.isSneaking() ? 12 : 1);
            phase = Utils.clampToRange(phase, 0, 360);
            BlockStorageAPI.set(location, "QP_OUTPUT_PHASE", phase);
        }
        if ("points".equals(name)) {
            int points = BlockStorageAPI.getInt(location, "POINTS");
            points += "add".equals(type) ? 1 : -1;
            points = Utils.clampToRange(points, 1, 13);
            BlockStorageAPI.set(location, "POINTS", points);
        }
        CreativeConcentrator.onConfigUpdated(location);
        this.update();
    }

    @Override
    protected void update() {
        if (this.isPanelHidden()) {
            return;
        }
        Optional<ConnectionGroup> group = this.getGroup();
        if (group.isEmpty()) {
            return;
        }
        Optional<Location> location = group.get().getLocation();
        if (location.isEmpty()) {
            return;
        }
        double power = BlockStorageAPI.getDouble(location.get(), "QP_OUTPUT_POWER");
        double frequency = BlockStorageAPI.getDouble(location.get(), "QP_OUTPUT_FREQUENCY");
        int phase = BlockStorageAPI.getInt(location.get(), "QP_OUTPUT_PHASE");
        int points = BlockStorageAPI.getInt(location.get(), "POINTS");
        this.container.setValue("power", Objects.toString(power));
        this.container.setValue("frequency", Objects.toString(frequency));
        this.container.setValue("phase", Objects.toString(phase));
        this.container.setValue("points", Objects.toString(points));
    }

    @Override
    protected Vector getOffset() {
        return new Vector(0.0, -0.3, 0.0);
    }
}

