/*
 * Decompiled with CFR 0.152.
 */
package org.metamechanists.quaptics.panels.config;

import io.github.bakedlibs.dough.common.ChatColors;
import java.util.Optional;
import org.bukkit.Color;
import org.bukkit.Location;
import org.bukkit.entity.Display;
import org.bukkit.entity.Entity;
import org.bukkit.entity.Interaction;
import org.bukkit.entity.TextDisplay;
import org.bukkit.util.Vector;
import org.jetbrains.annotations.NotNull;
import org.joml.Vector3d;
import org.metamechanists.quaptics.displaymodellib.builders.InteractionBuilder;
import org.metamechanists.quaptics.displaymodellib.models.ModelBuilder;
import org.metamechanists.quaptics.displaymodellib.models.components.ModelText;
import org.metamechanists.quaptics.displaymodellib.sefilib.entity.display.DisplayGroup;
import org.metamechanists.quaptics.storage.PersistentDataTraverser;
import org.metamechanists.quaptics.utils.id.complex.ConfigPanelAttributeId;
import org.metamechanists.quaptics.utils.id.complex.ConnectionGroupId;
import org.metamechanists.quaptics.utils.id.simple.DisplayGroupId;
import org.metamechanists.quaptics.utils.id.simple.InteractionId;

public class ConfigPanelAttribute {
    private static final float BUTTON_SIZE = 0.08f;
    private static final Vector BUTTON_ADJUSTMENT = new Vector(0.04f, 0.04f, 0.04f);
    private static final float HIDDEN_VIEW_RANGE = 0.0f;
    private static final float SHOWN_VIEW_RANGE = 1.0f;
    private static final double OFFSET_Y = 0.15;
    private static final double OFFSET_Z = 0.15;
    private final Vector offset;
    private final DisplayGroupId displayGroupId;
    private final InteractionId subButtonId;
    private final InteractionId addButtonId;

    public ConfigPanelAttribute(ConnectionGroupId groupId, @NotNull String name, @NotNull String key, @NotNull Location location, Vector offset, @NotNull Vector3d rotation, float size) {
        Vector subButtonLocation = new Vector(0.04, 0.0, -0.08).add(offset).add(BUTTON_ADJUSTMENT).rotateAroundY(rotation.y);
        Vector addButtonLocation = new Vector(0.41, 0.0, -0.08).add(offset).add(BUTTON_ADJUSTMENT).rotateAroundY(rotation.y);
        this.displayGroupId = new DisplayGroupId(new ModelBuilder().add("key", new ModelText().text(ChatColors.color(key)).brightness(15).background(Color.fromARGB((int)0, (int)0, (int)0, (int)0)).size(size).location(new Vector(-0.06, 0.15, 0.15).rotateAroundY(rotation.y).toVector3f()).rotation(rotation)).add("value", new ModelText().brightness(15).background(Color.fromARGB((int)0, (int)0, (int)0, (int)0)).size(size).location(new Vector(0.41, 0.15, 0.15).rotateAroundY(rotation.y).toVector3f()).rotation(rotation)).add("sub", new ModelText().text(ChatColors.color("&c-")).brightness(15).background(Color.fromARGB((int)0, (int)0, (int)0, (int)0)).size(size).location(new Vector(0.22, 0.15, 0.15).rotateAroundY(rotation.y).toVector3f()).rotation(rotation)).add("add", new ModelText().text(ChatColors.color("&a+")).brightness(15).background(Color.fromARGB((int)0, (int)0, (int)0, (int)0)).size(size).location(new Vector(0.59, 0.15, 0.15).rotateAroundY(rotation.y).toVector3f()).rotation(rotation)).buildAtLocation(location.clone().add(offset)).getParentUUID());
        Interaction subButton = new InteractionBuilder().width(0.08f).height(0.08f).build(location.clone().add(subButtonLocation));
        Interaction addButton = new InteractionBuilder().width(0.08f).height(0.08f).build(location.clone().add(addButtonLocation));
        PersistentDataTraverser subButtonTraverser = new PersistentDataTraverser(subButton.getUniqueId());
        subButtonTraverser.set("groupId", groupId);
        subButtonTraverser.set("name", name);
        subButtonTraverser.set("buttonType", "sub");
        PersistentDataTraverser addButtonTraverser = new PersistentDataTraverser(addButton.getUniqueId());
        addButtonTraverser.set("groupId", groupId);
        addButtonTraverser.set("name", name);
        addButtonTraverser.set("buttonType", "add");
        this.subButtonId = new InteractionId(subButton.getUniqueId());
        this.addButtonId = new InteractionId(addButton.getUniqueId());
        this.offset = offset;
        this.saveData();
    }

    public ConfigPanelAttribute(ConfigPanelAttributeId displayGroupId) {
        PersistentDataTraverser traverser = new PersistentDataTraverser(displayGroupId);
        this.displayGroupId = new DisplayGroupId(displayGroupId);
        this.offset = traverser.getVector("offset");
        this.subButtonId = traverser.getInteractionId("subButtonId");
        this.addButtonId = traverser.getInteractionId("addButtonId");
    }

    private void saveData() {
        PersistentDataTraverser traverser = new PersistentDataTraverser(this.displayGroupId);
        traverser.set("offset", this.offset);
        traverser.set("subButtonId", this.subButtonId);
        traverser.set("addButtonId", this.addButtonId);
    }

    public ConfigPanelAttributeId getId() {
        return new ConfigPanelAttributeId(this.displayGroupId);
    }

    private Optional<DisplayGroup> getDisplayGroup() {
        return ((Optional)this.displayGroupId.get()).isPresent() ? this.displayGroupId.get() : Optional.empty();
    }

    private Optional<TextDisplay> getValue() {
        Optional<TextDisplay> optional;
        Display display;
        if (this.getDisplayGroup().isPresent() && (display = this.getDisplayGroup().get().getDisplays().get("value")) instanceof TextDisplay) {
            TextDisplay textDisplay = (TextDisplay)display;
            optional = Optional.of(textDisplay);
        } else {
            optional = Optional.empty();
        }
        return optional;
    }

    private Optional<Interaction> getAddButton() {
        return ((Optional)this.addButtonId.get()).isPresent() ? this.addButtonId.get() : Optional.empty();
    }

    private Optional<Interaction> getSubButton() {
        return ((Optional)this.subButtonId.get()).isPresent() ? this.subButtonId.get() : Optional.empty();
    }

    public void setValue(@NotNull String text) {
        this.getValue().ifPresent(value -> value.setText(ChatColors.color(text)));
    }

    public void setHidden(boolean hidden) {
        ((Optional)this.displayGroupId.get()).ifPresent(group -> group.getDisplays().values().forEach(display -> display.setViewRange(hidden ? 0.0f : 1.0f)));
    }

    public void remove() {
        ((Optional)this.displayGroupId.get()).ifPresent(group -> {
            group.getDisplays().values().forEach(Entity::remove);
            group.remove();
        });
        this.getAddButton().ifPresent(Entity::remove);
        this.getSubButton().ifPresent(Entity::remove);
    }
}

