/*
 * Decompiled with CFR 0.152.
 */
package org.metamechanists.quaptics.metalib.sefilib.world;

import javax.annotation.Nonnull;
import org.bukkit.World;

public enum TimePeriod {
    SUNRISE(23000L, 23999L),
    DAY(24000L, 11999L),
    SUNSET(12000L, 12999L),
    NIGHT(13000L, 22999L),
    WAKE_UP(24000L, 24000L),
    BED_TIME_RAIN(12010L, 23999L),
    BED_TIME_CLEAR(12542L, 23999L),
    MOON_HIDDEN(167L, 11833L),
    MOON_VISIBLE(11834L, 166L),
    VILLAGER_WORK(2000L, 8999L),
    VILLAGER_SOCIALISE(9000L, 11999L),
    VILLAGER_BED_TIME(12000L, 23999L),
    SKY_LIGHT_WAX_CLEAR(22331L, 23961L),
    SKY_LIGHT_WAX_RAIN(22331L, 23992L),
    SKY_LIGHT_WANE_CLEAR(12040L, 13670L),
    SKY_LIGHT_WANE_RAIN(12010L, 13670L),
    MOB_SPAWN_CLEAR(13188L, 22812L),
    MOB_SPAWN_RAIN(12969L, 23031L);

    private final long start;
    private final long end;

    private TimePeriod(long start, long end) {
        this.start = start;
        this.end = end;
    }

    public long getStart() {
        return this.start;
    }

    public long getEnd() {
        return this.end;
    }

    public static boolean isDay(@Nonnull World world) {
        return TimePeriod.isDay(world.getTime());
    }

    public static boolean isDay(Long time) {
        return time < 13000L || time > 24000L;
    }

    public static boolean isNight(@Nonnull World world) {
        return TimePeriod.isNight(world.getTime());
    }

    public static boolean isNight(@Nonnull Long time) {
        return !TimePeriod.isDay(time);
    }

    public static boolean isActive(@Nonnull World world, @Nonnull TimePeriod timePeriod) {
        return TimePeriod.isActive(world.getTime(), timePeriod);
    }

    public static boolean isActive(@Nonnull Long time, @Nonnull TimePeriod timePeriod) {
        return time >= timePeriod.getStart() && time <= timePeriod.getEnd();
    }

    public static boolean villagersAwake(@Nonnull World world) {
        return TimePeriod.villagersAwake(world.getTime());
    }

    public static boolean villagersAwake(@Nonnull Long time) {
        return time >= WAKE_UP.getStart() && time <= VILLAGER_BED_TIME.getEnd();
    }

    public static boolean moonOut(@Nonnull World world) {
        if (world.getEnvironment() == World.Environment.NORMAL) {
            return TimePeriod.moonOut(world.getTime());
        }
        return false;
    }

    public static boolean moonOut(@Nonnull Long time) {
        return time >= MOON_VISIBLE.getStart() && time <= MOON_HIDDEN.getEnd();
    }

    public static boolean naturalMobsCanSpawn(World world) {
        long time = world.getTime();
        return world.isClearWeather() ? TimePeriod.naturalMobsCanSpawn(time, false) : TimePeriod.naturalMobsCanSpawn(time, true);
    }

    public static boolean naturalMobsCanSpawn(long time, boolean rain) {
        return rain ? time >= MOB_SPAWN_RAIN.getStart() && time <= MOB_SPAWN_RAIN.getEnd() : time >= MOB_SPAWN_CLEAR.getStart() && time <= MOB_SPAWN_CLEAR.getEnd();
    }

    public static boolean isLight(@Nonnull World world) {
        if (world.getEnvironment() == World.Environment.NORMAL) {
            return TimePeriod.isDay(world.getTime());
        }
        return false;
    }

    public static boolean isDark(@Nonnull World world) {
        return !TimePeriod.isLight(world);
    }
}

