/*
 * Decompiled with CFR 0.152.
 */
package org.metamechanists.quaptics.metalib.language;

import java.util.Map;
import org.bukkit.entity.Player;
import org.bukkit.plugin.Plugin;
import org.metamechanists.quaptics.metalib.utils.ColorUtils;
import org.metamechanists.quaptics.metalib.yaml.YamlTraverser;

public class LanguageStorage {
    private final Plugin plugin;
    private final YamlTraverser languageTraverser;

    public LanguageStorage(Plugin plugin) {
        plugin.saveResource("language.yml", true);
        this.plugin = plugin;
        this.languageTraverser = new YamlTraverser(plugin, "language.yml");
    }

    private String fillPlaceholders(String message, Object ... placeholders) {
        int i = 1;
        for (Object rawValue : placeholders) {
            if (rawValue instanceof Player) {
                Player value = (Player)rawValue;
                message = message.replace("{" + i + "}", value.getName());
            } else if (rawValue instanceof String) {
                String value = (String)rawValue;
                message = message.replace("{" + i + "}", value);
            } else if (rawValue instanceof Integer) {
                Integer value = (Integer)rawValue;
                message = message.replace("{" + i + "}", value.toString());
            } else if (rawValue instanceof Double) {
                Double value = (Double)rawValue;
                message = message.replace("{" + i + "}", value.toString());
            } else {
                this.plugin.getLogger().severe("Could not substitute placeholder of type " + rawValue.getClass());
            }
            ++i;
        }
        return message;
    }

    private String fillColors(String message) {
        for (Map.Entry<String, String> colorPair : ColorUtils.getColorMap().entrySet()) {
            message = message.replace("{" + colorPair.getKey() + "}", colorPair.getValue());
        }
        return message;
    }

    public final void sendLanguageMessage(Player player, String path, Object ... placeholders) {
        player.sendMessage(this.getLanguageEntry(path, placeholders));
    }

    public final String getLanguageEntry(String path, Object ... placeholders) {
        String message = (String)this.languageTraverser.get(path);
        if (message == null) {
            this.plugin.getLogger().severe("Could not find language entry " + path);
            return "Language file entry missing. Contact a server admin and show them this message!";
        }
        message = this.fillPlaceholders(message, placeholders);
        message = ColorUtils.formatColors(message);
        message = this.fillColors(message);
        return message;
    }
}

