/*
 * Decompiled with CFR 0.152.
 */
package org.metamechanists.quaptics.metalib.dough.scheduling;

import java.util.function.IntConsumer;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import org.apache.commons.lang.Validate;

class TaskNode {
    private final IntConsumer runnable;
    private final boolean asynchronous;
    private int delay = 0;
    private TaskNode nextNode;

    protected TaskNode(@Nonnull IntConsumer consumer, boolean async) {
        this.runnable = consumer;
        this.asynchronous = async;
    }

    protected TaskNode(@Nonnull IntConsumer consumer, int delay, boolean async) {
        this.runnable = consumer;
        this.delay = delay;
        this.asynchronous = async;
    }

    protected boolean hasNextNode() {
        return this.nextNode != null;
    }

    @Nullable
    public TaskNode getNextNode() {
        return this.nextNode;
    }

    public void setNextNode(@Nullable TaskNode node) {
        this.nextNode = node;
    }

    public void execute(int index) {
        this.runnable.accept(index);
    }

    public boolean isAsynchronous() {
        return this.asynchronous;
    }

    public int getDelay() {
        return this.delay;
    }

    public void setDelay(int delay) {
        Validate.isTrue((delay >= 0 ? 1 : 0) != 0, (String)"The delay cannot be negative.");
        this.delay = delay;
    }
}

