/*
 * Decompiled with CFR 0.152.
 */
package org.metamechanists.quaptics.implementation.tools.pointwand;

import it.unimi.dsi.fastutil.Pair;
import java.util.Optional;
import org.bukkit.Color;
import org.bukkit.Location;
import org.bukkit.entity.Entity;
import org.bukkit.entity.EntityType;
import org.bukkit.entity.Player;
import org.bukkit.event.EventHandler;
import org.bukkit.event.EventPriority;
import org.bukkit.event.Listener;
import org.bukkit.event.player.PlayerInteractEntityEvent;
import org.bukkit.event.player.PlayerItemHeldEvent;
import org.bukkit.event.player.PlayerMoveEvent;
import org.bukkit.inventory.ItemStack;
import org.bukkit.inventory.PlayerInventory;
import org.bukkit.util.Vector;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.metamechanists.quaptics.connections.ConnectionPoint;
import org.metamechanists.quaptics.connections.Link;
import org.metamechanists.quaptics.implementation.base.ConnectedBlock;
import org.metamechanists.quaptics.implementation.tools.pointwand.PointWand;
import org.metamechanists.quaptics.storage.PersistentDataTraverser;
import org.metamechanists.quaptics.utils.PersistentDataUtils;
import org.metamechanists.quaptics.utils.id.complex.ConnectionPointId;

public class PointWandListener
implements Listener {
    private static final Color SELECTED_COLOR = Color.fromRGB((int)0, (int)255, (int)255);
    private static final Pair<ItemStack, PersistentDataTraverser> EMPTY = Pair.of(null, null);

    @Nullable
    private static Vector getLineSphereIntersections(Vector sphereCenter, @NotNull Vector lineOrigin, @NotNull Vector lineDirection, float r) {
        Vector f = lineOrigin.clone().subtract(sphereCenter);
        float discriminant = (float)(Math.pow(lineDirection.clone().dot(f), 2.0) - ((double)f.toVector3f().absolute().lengthSquared() - Math.pow(r, 2.0)));
        if (discriminant < 0.0f) {
            return null;
        }
        float d1 = -((float)(lineDirection.dot(f) + Math.sqrt(discriminant)));
        float d2 = -((float)(lineDirection.dot(f) - Math.sqrt(discriminant)));
        Vector solution1 = lineOrigin.clone().add(lineDirection.clone().multiply(d1));
        Vector solution2 = lineOrigin.clone().add(lineDirection.clone().multiply(d2));
        if (d1 < 0.0f && d2 < 0.0f) {
            return null;
        }
        if (d1 > 0.0f) {
            return solution1;
        }
        if (d2 > 0.0f) {
            return solution2;
        }
        if (solution1.length() < solution2.length()) {
            return solution1;
        }
        return solution2;
    }

    public static Pair<ItemStack, PersistentDataTraverser> getPointWand(Player player) {
        ItemStack stack;
        PlayerInventory inventory = player.getInventory();
        boolean mainHand = "QP_POINT_WAND".equals(PersistentDataUtils.getSlimefunId(inventory.getItemInMainHand()));
        ItemStack itemStack = stack = mainHand ? inventory.getItemInMainHand() : inventory.getItemInOffHand();
        if (stack == null || stack.getType().isAir() || !stack.hasItemMeta()) {
            return EMPTY;
        }
        PersistentDataTraverser traverser = new PersistentDataTraverser(stack);
        if (!"QP_POINT_WAND".equals(traverser.getSlimefunId())) {
            return EMPTY;
        }
        return Pair.of((Object)stack, (Object)traverser);
    }

    @EventHandler(priority=EventPriority.MONITOR, ignoreCancelled=true)
    public static void moveEvent(@NotNull PlayerMoveEvent event) {
        Player player = event.getPlayer();
        Pair<ItemStack, PersistentDataTraverser> wand = PointWandListener.getPointWand(player);
        if (wand.equals(EMPTY)) {
            return;
        }
        ConnectionPointId id = ((PersistentDataTraverser)wand.value()).getConnectionPointId("point");
        if (id == null) {
            return;
        }
        ((Optional)id.get()).ifPresent(point -> point.getGroup().ifPresent(group -> {
            float sphereRadius;
            Location newLocation = event.getTo().clone();
            Location groupLocation = group.getLocation().orElse(null);
            if (groupLocation == null) {
                return;
            }
            if (newLocation.distanceSquared(groupLocation) > 9.0) {
                PointWand.tryUnSelect((ItemStack)wand.key(), (PersistentDataTraverser)wand.value());
                return;
            }
            ConnectedBlock block = group.getBlock();
            Location centerLocation = groupLocation.getBlock().getLocation().toCenterLocation();
            Vector cameraPosition = newLocation.clone().add(0.0, player.getEyeHeight(), 0.0).toVector();
            Vector unitVectorDirection = newLocation.getDirection().normalize();
            Vector spherePosition = centerLocation.toVector();
            Vector intersect = PointWandListener.getLineSphereIntersections(spherePosition, cameraPosition, unitVectorDirection, sphereRadius = block.getConnectionRadius());
            if (intersect == null) {
                return;
            }
            point.changeLocation(intersect.toLocation(newLocation.getWorld()));
            point.getLink().ifPresent(Link::regenerateBeam);
        }));
    }

    @EventHandler(priority=EventPriority.MONITOR, ignoreCancelled=true)
    public static void interactEvent(@NotNull PlayerInteractEntityEvent event) {
        Entity clickedEntity = event.getRightClicked();
        if (clickedEntity.getType() != EntityType.INTERACTION) {
            return;
        }
        Pair<ItemStack, PersistentDataTraverser> wand = PointWandListener.getPointWand(event.getPlayer());
        if (wand.equals(EMPTY)) {
            return;
        }
        if (PointWand.tryUnSelect((ItemStack)wand.key(), (PersistentDataTraverser)wand.value())) {
            return;
        }
        ConnectionPointId id = new ConnectionPointId(clickedEntity.getUniqueId());
        if (!id.isValid() || ((Optional)id.get()).isEmpty()) {
            return;
        }
        ConnectionPoint point = (ConnectionPoint)((Optional)id.get()).get();
        if (point.isGlowing()) {
            return;
        }
        ((PersistentDataTraverser)wand.value()).set("point", id);
        ((PersistentDataTraverser)wand.value()).save((ItemStack)wand.key());
        point.glowColor(SELECTED_COLOR);
    }

    @EventHandler(priority=EventPriority.MONITOR, ignoreCancelled=true)
    public static void scrollEvent(@NotNull PlayerItemHeldEvent event) {
        PointWand.tryUnSelect(event.getPlayer().getInventory().getItem(event.getPreviousSlot()));
    }
}

