/*
 * Decompiled with CFR 0.152.
 */
package org.metamechanists.quaptics.implementation.multiblocks.reactor;

import io.github.thebusybiscuit.slimefun4.api.items.ItemGroup;
import io.github.thebusybiscuit.slimefun4.api.items.SlimefunItemStack;
import io.github.thebusybiscuit.slimefun4.api.recipes.RecipeType;
import java.util.List;
import org.bukkit.Location;
import org.bukkit.Material;
import org.bukkit.entity.Player;
import org.bukkit.inventory.ItemStack;
import org.bukkit.util.Vector;
import org.jetbrains.annotations.NotNull;
import org.metamechanists.quaptics.connections.ConnectionGroup;
import org.metamechanists.quaptics.connections.ConnectionPoint;
import org.metamechanists.quaptics.connections.ConnectionPointType;
import org.metamechanists.quaptics.connections.Link;
import org.metamechanists.quaptics.displaymodellib.models.ModelBuilder;
import org.metamechanists.quaptics.displaymodellib.models.components.ModelCuboid;
import org.metamechanists.quaptics.displaymodellib.sefilib.entity.display.DisplayGroup;
import org.metamechanists.quaptics.implementation.Settings;
import org.metamechanists.quaptics.implementation.base.ConnectedBlock;
import org.metamechanists.quaptics.implementation.multiblocks.reactor.ReactorController;
import org.metamechanists.quaptics.items.Lore;
import org.metamechanists.quaptics.items.Tier;
import org.metamechanists.quaptics.utils.BlockStorageAPI;
import org.metamechanists.quaptics.utils.id.complex.ConnectionGroupId;
import org.metamechanists.quaptics.utils.id.complex.ConnectionPointId;

public class ReactorRing
extends ConnectedBlock {
    public static final Settings REACTOR_RING_SETTINGS = Settings.builder().tier(Tier.INTERMEDIATE).build();
    public static final SlimefunItemStack REACTOR_RING = new SlimefunItemStack("QP_REACTOR_RING", Material.WHITE_CONCRETE, "&6Reactor Ring", Lore.create(REACTOR_RING_SETTINGS, Lore.multiblockComponent()));
    private final List<Vector> possibleControllerLocations = List.of(new Vector(3, 0, 0), new Vector(2, 0, 2), new Vector(0, 0, 3), new Vector(-2, 0, 2), new Vector(-3, 0, 0), new Vector(-2, 0, -2), new Vector(0, 0, -3), new Vector(2, 0, -2));

    public ReactorRing(ItemGroup itemGroup, SlimefunItemStack item, RecipeType recipeType, ItemStack[] recipe, Settings settings) {
        super(itemGroup, item, recipeType, recipe, settings);
    }

    @Override
    public float getConnectionRadius() {
        return 0.7f;
    }

    @Override
    public void connect(@NotNull ConnectionPointId from, @NotNull ConnectionPointId to) {
    }

    @Override
    protected DisplayGroup initModel(@NotNull Location location, @NotNull Player player) {
        Vector controllerPosition = this.findController(location);
        return new ModelBuilder().add("ring1a", new ModelCuboid().material(Material.WHITE_CONCRETE).facing(controllerPosition.toVector3f()).size(0.2f, 0.477f, 0.2f).location(0.0f, 0.0f, 0.4f)).add("ring1b", new ModelCuboid().material(Material.WHITE_CONCRETE).facing(controllerPosition.toVector3f()).size(0.2f, 0.477f, 0.2f).location(0.0f, 0.0f, -0.4f)).add("ring2a", new ModelCuboid().material(Material.WHITE_CONCRETE).facing(controllerPosition.toVector3f()).size(0.2f, 0.2f, 0.477f).location(0.0f, 0.4f, 0.0f)).add("ring2b", new ModelCuboid().material(Material.WHITE_CONCRETE).facing(controllerPosition.toVector3f()).size(0.2f, 0.2f, 0.477f).location(0.0f, -0.4f, 0.0f)).add("ring3a", new ModelCuboid().material(Material.WHITE_CONCRETE).facing(controllerPosition.toVector3f()).size(0.2f, 0.2f, 0.365f).location(0.0f, 0.3f, 0.3f).rotation(0.7853981633974483, 0.0, 0.0)).add("ring3b", new ModelCuboid().material(Material.WHITE_CONCRETE).facing(controllerPosition.toVector3f()).size(0.2f, 0.2f, 0.365f).location(0.0f, -0.3f, -0.3f).rotation(0.7853981633974483, 0.0, 0.0)).add("ring4a", new ModelCuboid().material(Material.WHITE_CONCRETE).facing(controllerPosition.toVector3f()).size(0.2f, 0.365f, 0.2f).location(0.0f, 0.3f, -0.3f).rotation(0.7853981633974483, 0.0, 0.0)).add("ring4b", new ModelCuboid().material(Material.WHITE_CONCRETE).facing(controllerPosition.toVector3f()).size(0.2f, 0.365f, 0.2f).location(0.0f, -0.3f, 0.3f).rotation(0.7853981633974483, 0.0, 0.0)).add("connection2", new ModelCuboid().material(Material.GRAY_CONCRETE).facing(controllerPosition.toVector3f()).size(0.15f, 0.15f, 0.2f).location(0.0f, 0.0f, -0.6f)).buildAtBlockCenter(location);
    }

    @Override
    protected List<ConnectionPoint> initConnectionPoints(ConnectionGroupId groupId, Player player, Location location) {
        Vector controllerDirection = this.findController(location).normalize();
        return List.of(new ConnectionPoint(ConnectionPointType.INPUT, groupId, "input", location.clone().toCenterLocation().add(controllerDirection.clone().multiply(-this.getConnectionRadius()))));
    }

    @Override
    protected void initBlockStorage(@NotNull Location location, @NotNull Player player) {
        BlockStorageAPI.set(location, "QP_INPUT_POWER", 0.0);
    }

    @Override
    public void onInputLinkUpdated(@NotNull ConnectionGroup group, @NotNull Location location) {
        if (this.doBurnoutCheck(group, "input")) {
            return;
        }
        double inputPower = ReactorRing.getLink(location, "input").map(Link::getPower).orElse(0.0);
        BlockStorageAPI.set(location, "QP_INPUT_POWER", inputPower);
    }

    @NotNull
    private Vector findController(@NotNull Location location) {
        for (Vector vector : this.possibleControllerLocations) {
            if (!(BlockStorageAPI.check(location.clone().add(vector)) instanceof ReactorController)) continue;
            return vector.clone();
        }
        return new Vector(0, 0, 3);
    }
}

