/*
 * Decompiled with CFR 0.152.
 */
package org.metamechanists.quaptics.implementation.burnout;

import java.util.Collection;
import java.util.HashSet;
import org.bukkit.event.EventHandler;
import org.bukkit.event.EventPriority;
import org.bukkit.event.Listener;
import org.bukkit.event.block.BlockBreakEvent;
import org.metamechanists.quaptics.implementation.burnout.BurnoutRunnable;

public class BurnoutManager
implements Listener {
    private static final Collection<BurnoutRunnable> burnouts = new HashSet<BurnoutRunnable>();

    public static void addBurnout(BurnoutRunnable runnable) {
        burnouts.add(runnable);
        runnable.run();
    }

    public static void removeBurnout(BurnoutRunnable runnable) {
        burnouts.remove((Object)runnable);
    }

    public static void stopBurnouts() {
        burnouts.forEach(BurnoutRunnable::stopEarly);
    }

    @EventHandler(priority=EventPriority.LOWEST)
    public static void onBlockBreak(BlockBreakEvent event) {
        for (BurnoutRunnable runnable : burnouts) {
            if (!event.getBlock().equals(runnable.getLocation().getBlock())) continue;
            event.setCancelled(true);
            runnable.stopEarly();
            return;
        }
    }
}

