/*
 * Decompiled with CFR 0.152.
 */
package org.metamechanists.quaptics.implementation.blocks.concentrators;

import com.google.common.collect.Lists;
import io.github.thebusybiscuit.slimefun4.api.items.ItemGroup;
import io.github.thebusybiscuit.slimefun4.api.items.SlimefunItem;
import io.github.thebusybiscuit.slimefun4.api.items.SlimefunItemStack;
import io.github.thebusybiscuit.slimefun4.api.recipes.RecipeType;
import java.util.ArrayList;
import java.util.Comparator;
import java.util.List;
import javax.annotation.OverridingMethodsMustInvokeSuper;
import me.mrCookieSlime.CSCoreLibPlugin.Configuration.Config;
import org.bukkit.Location;
import org.bukkit.Material;
import org.bukkit.block.Block;
import org.bukkit.entity.Player;
import org.bukkit.event.block.BlockPlaceEvent;
import org.bukkit.inventory.ItemStack;
import org.bukkit.util.Vector;
import org.jetbrains.annotations.NotNull;
import org.metamechanists.quaptics.connections.ConnectionGroup;
import org.metamechanists.quaptics.connections.ConnectionPoint;
import org.metamechanists.quaptics.connections.ConnectionPointType;
import org.metamechanists.quaptics.connections.Link;
import org.metamechanists.quaptics.displaymodellib.models.ModelBuilder;
import org.metamechanists.quaptics.displaymodellib.models.components.ModelCuboid;
import org.metamechanists.quaptics.displaymodellib.sefilib.entity.display.DisplayGroup;
import org.metamechanists.quaptics.displaymodellib.transformations.TransformationUtils;
import org.metamechanists.quaptics.implementation.Settings;
import org.metamechanists.quaptics.implementation.attachments.ConfigPanelBlock;
import org.metamechanists.quaptics.implementation.base.ConnectedBlock;
import org.metamechanists.quaptics.items.Lore;
import org.metamechanists.quaptics.panels.config.ConfigPanel;
import org.metamechanists.quaptics.panels.config.implementation.CreativeConcentratorConfigPanel;
import org.metamechanists.quaptics.utils.BlockStorageAPI;
import org.metamechanists.quaptics.utils.Colors;
import org.metamechanists.quaptics.utils.id.complex.ConfigPanelId;
import org.metamechanists.quaptics.utils.id.complex.ConnectionGroupId;

public class CreativeConcentrator
extends ConnectedBlock
implements ConfigPanelBlock {
    public static final SlimefunItemStack CREATIVE_CONCENTRATOR = new SlimefunItemStack("QP_CREATIVE_CONCENTRATOR", Material.PURPLE_GLAZED_TERRACOTTA, "&dCreative Concentrator", new String[]{Colors.CREATIVE.getFormattedColor() + "Creative", "&7\u25cf Concentrates &kwhatlol &7into a quaptic ray", "&7\u25cf Control the output with the panel (try shifting)", "&8\u21e8 " + Lore.POWER_SYMBOL + "&7Max Power Output &e\u221e &8W", "&8\u21e8 " + Lore.FREQUENCY_SYMBOL + "&7Max Frequency Output &e\u221e &8Hz", "&8\u21e8 " + Lore.PHASE_SYMBOL + "&7Max Phase Output &e\u221e &8\u00b0"});
    public static final float RADIUS = 0.55f;
    public static final int MAX_POINTS = 13;
    public static final float STARTING_ANGLE = 0.48332193f;
    private static final Vector RELATIVE_PANEL_LOCATION = new Vector(0.0, 0.15, -0.6);
    private static final Vector OUTPUT_STARTING_LOCATION = new Vector(0.0f, 0.0f, 0.55f);

    public CreativeConcentrator(ItemGroup itemGroup, SlimefunItemStack item) {
        super(itemGroup, item, RecipeType.NULL, new ItemStack[0], Settings.builder().build());
    }

    @Override
    public float getConnectionRadius() {
        return 0.55f;
    }

    @Override
    protected DisplayGroup initModel(@NotNull Location location, @NotNull Player player) {
        return new ModelBuilder().add("center", new ModelCuboid().material(Material.PURPLE_GLAZED_TERRACOTTA).brightness(15).size(0.2f)).add("plate", new ModelCuboid().material(Material.GRAY_CONCRETE).rotation(0.7853981633974483).size(0.6f, 0.1f, 0.6f)).add("glass", new ModelCuboid().material(Material.TINTED_GLASS).rotation(0.7853981633974483).size(0.4f)).buildAtBlockCenter(location);
    }

    @Override
    public ConfigPanel createPanel(Location location, Player player, @NotNull ConnectionGroup group) {
        return new CreativeConcentratorConfigPanel(CreativeConcentrator.formatPointLocation(player, location, RELATIVE_PANEL_LOCATION), group.getId(), (float)TransformationUtils.yawToCardinalDirection(player.getEyeLocation().getYaw()));
    }

    @Override
    public ConfigPanel getPanel(ConfigPanelId panelId, ConnectionGroupId groupId) {
        return new CreativeConcentratorConfigPanel(panelId, groupId);
    }

    @Override
    protected List<ConnectionPoint> initConnectionPoints(ConnectionGroupId groupId, Player player, Location location) {
        return List.of(new ConnectionPoint(ConnectionPointType.OUTPUT, groupId, "output 1", CreativeConcentrator.formatPointLocation(player, location, OUTPUT_STARTING_LOCATION)));
    }

    @Override
    protected void initBlockStorage(@NotNull Location location, @NotNull Player player) {
        BlockStorageAPI.set(location, "QP_OUTPUT_POWER", 0);
        BlockStorageAPI.set(location, "QP_OUTPUT_FREQUENCY", 0);
        BlockStorageAPI.set(location, "QP_OUTPUT_PHASE", 0);
        BlockStorageAPI.set(location, "POINTS", 1);
        BlockStorageAPI.set(location, "QP_FACING", player.getEyeLocation().getYaw());
    }

    @Override
    @OverridingMethodsMustInvokeSuper
    protected void onPlace(@NotNull BlockPlaceEvent event) {
        super.onPlace(event);
        this.onPlaceConfigPanelBlock(event);
    }

    @Override
    @OverridingMethodsMustInvokeSuper
    protected void onBreak(@NotNull Location location) {
        super.onBreak(location);
        this.onBreakConfigPanelBlock(location);
    }

    @Override
    protected void onSlimefunTick(@NotNull Block block, SlimefunItem item, Config data) {
        super.onSlimefunTick(block, item, data);
        Location location = block.getLocation();
        List<Link> outgoingLinks = CreativeConcentrator.getOutgoingLinks(location);
        outgoingLinks.forEach(link -> {
            double power = BlockStorageAPI.getDouble(location, "QP_OUTPUT_POWER");
            double frequency = BlockStorageAPI.getDouble(location, "QP_OUTPUT_FREQUENCY");
            int phase = BlockStorageAPI.getInt(location, "QP_OUTPUT_PHASE");
            link.setPowerFrequencyPhase(power, frequency, phase);
        });
    }

    public static void onConfigUpdated(Location location) {
        CreativeConcentrator.getGroup(location).ifPresent(group -> {
            int i;
            float yaw = BlockStorageAPI.getFloat(location, "QP_FACING");
            ArrayList<ConnectionPoint> points = new ArrayList<ConnectionPoint>(group.getPointList());
            points.sort(Comparator.comparingInt(point -> Integer.parseInt(point.getName().split(" ")[1])));
            Lists.reverse(points);
            int pointCount = BlockStorageAPI.getInt(location, "POINTS");
            for (i = 1; i <= points.size(); ++i) {
                if (i <= pointCount) continue;
                group.removePoint((ConnectionPoint)points.get(i - 1)).ifPresent(point -> {
                    point.getLink().ifPresent(Link::remove);
                    point.remove();
                });
            }
            for (i = 2; i <= pointCount; ++i) {
                Location pointLocation = CreativeConcentrator.formatPointLocation(yaw, location, CreativeConcentrator.getRelativeOutputLocation(i - 1));
                if (points.size() >= i) {
                    ((ConnectionPoint)points.get(i - 1)).changeLocation(pointLocation);
                    continue;
                }
                group.addPoint(new ConnectionPoint(ConnectionPointType.OUTPUT, group.getId(), "output " + i, pointLocation));
            }
        });
    }

    public static Vector getRelativeOutputLocation(int i) {
        return OUTPUT_STARTING_LOCATION.clone().rotateAroundY((double)(0.48332193f * (float)i));
    }
}

