/*
 * Decompiled with CFR 0.152.
 */
package org.metamechanists.quaptics.implementation.attachments;

import io.github.thebusybiscuit.slimefun4.utils.SlimefunUtils;
import java.util.Map;
import java.util.Optional;
import org.bukkit.Location;
import org.bukkit.inventory.ItemStack;
import org.jetbrains.annotations.NotNull;
import org.metamechanists.quaptics.implementation.attachments.ItemHolderBlock;
import org.metamechanists.quaptics.utils.BlockStorageAPI;

@FunctionalInterface
public interface ItemProcessor {
    default public boolean isProcessing(@NotNull Location location) {
        return BlockStorageAPI.getBoolean(location, "QP_CRAFT_IN_PROGRESS");
    }

    default public void startProcessing(@NotNull Location location) {
        BlockStorageAPI.set(location, "QP_TIME_SINCE_CRAFT_STARTED", 0);
        BlockStorageAPI.set(location, "QP_CRAFT_IN_PROGRESS", true);
    }

    default public void cancelProcessing(@NotNull Location location) {
        BlockStorageAPI.set(location, "QP_TIME_SINCE_CRAFT_STARTED", 0);
        BlockStorageAPI.set(location, "QP_CRAFT_IN_PROGRESS", false);
    }

    default public void completeProcessing(@NotNull Location location) {
        Optional<ItemStack> stack = ItemHolderBlock.getStack(location, "item");
        if (stack.isEmpty()) {
            return;
        }
        BlockStorageAPI.set(location, "QP_TIME_SINCE_CRAFT_STARTED", 0);
        BlockStorageAPI.set(location, "QP_CRAFT_IN_PROGRESS", false);
        ItemHolderBlock.insertItem(location, "item", this.getRecipes().get(stack.get()));
    }

    default public void tickProcessing(@NotNull Location location, int tickInterval) {
        double secondsSinceCraftStarted = BlockStorageAPI.getDouble(location, "QP_TIME_SINCE_CRAFT_STARTED");
        BlockStorageAPI.set(location, "QP_TIME_SINCE_CRAFT_STARTED", secondsSinceCraftStarted += (double)tickInterval / 20.0);
    }

    default public boolean isValidRecipe(@NotNull ItemStack inputStack) {
        return this.getRecipes().keySet().stream().anyMatch(input -> SlimefunUtils.isItemSimilar((ItemStack)input, (ItemStack)inputStack, (boolean)true));
    }

    public Map<ItemStack, ItemStack> getRecipes();
}

