/*
 * Decompiled with CFR 0.152.
 */
package org.metamechanists.quaptics.implementation.attachments;

import java.util.Optional;
import org.bukkit.Location;
import org.bukkit.entity.ItemDisplay;
import org.bukkit.entity.Player;
import org.bukkit.inventory.ItemStack;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.metamechanists.quaptics.connections.ConnectionGroup;
import org.metamechanists.quaptics.implementation.base.QuapticBlock;
import org.metamechanists.quaptics.metalib.utils.ItemUtils;
import org.metamechanists.quaptics.utils.BlockStorageAPI;

public interface ItemHolderBlock {
    @Nullable
    default public ItemStack getEmptyItemStack() {
        return null;
    }

    default public boolean isEmptyItemStack(@NotNull ItemStack itemStack) {
        return itemStack.getType().isEmpty();
    }

    public static Optional<ItemStack> getStack(@NotNull ConnectionGroup group, @NotNull String name) {
        Optional<Location> location = group.getLocation();
        if (location.isEmpty()) {
            return Optional.empty();
        }
        return ItemHolderBlock.getStack(location.get(), name);
    }

    public static Optional<ItemStack> getStack(@NotNull Location location, @NotNull String name) {
        Optional<ItemDisplay> itemDisplay = QuapticBlock.getItemDisplay(location, name);
        if (itemDisplay.isEmpty()) {
            return Optional.empty();
        }
        ItemStack stack = itemDisplay.get().getItemStack();
        return stack == null || stack.getItemMeta() == null ? Optional.empty() : Optional.of(stack);
    }

    public static void insertItem(Location location, @NotNull String name, @NotNull ItemStack itemStack) {
        Optional<ItemDisplay> itemDisplay = QuapticBlock.getItemDisplay(location, name);
        if (itemDisplay.isEmpty()) {
            return;
        }
        itemDisplay.get().setItemStack(itemStack);
    }

    default public Optional<ItemStack> removeItem(@NotNull Location location, @NotNull String name) {
        Optional<ItemDisplay> itemDisplay = QuapticBlock.getItemDisplay(location, name);
        if (itemDisplay.isEmpty()) {
            return Optional.empty();
        }
        ItemStack itemStack = itemDisplay.get().getItemStack();
        itemDisplay.get().setItemStack(this.getEmptyItemStack());
        return Optional.ofNullable(itemStack);
    }

    default public void itemHolderInteract(@NotNull Location location, @NotNull String name, @NotNull Player player) {
        this.itemHolderInteract(location, name, player, 1);
    }

    default public void itemHolderInteract(@NotNull Location location, @NotNull String name, @NotNull Player player, int maxAmount) {
        int amount;
        Optional<ItemStack> currentStack = this.removeItem(location, name);
        BlockStorageAPI.set(location, "QP_IS_HOLDING_ITEM", false);
        if (currentStack.isPresent() && !this.isEmptyItemStack(currentStack.get())) {
            this.onRemove(location, name, currentStack.get()).ifPresent(itemStack -> ItemUtils.addOrDropItemMainHand(player, itemStack));
            return;
        }
        ItemStack mainHand = player.getInventory().getItemInMainHand();
        ItemStack itemStack2 = mainHand.asQuantity(amount = Math.min(mainHand.getAmount(), Math.min(mainHand.getMaxStackSize(), maxAmount)));
        if (itemStack2.getType().isEmpty() || !this.onInsert(location, name, itemStack2, player)) {
            return;
        }
        mainHand.subtract(amount);
        ItemHolderBlock.insertItem(location, name, itemStack2);
        BlockStorageAPI.set(location, "QP_IS_HOLDING_ITEM", true);
    }

    default public void onBreakItemHolderBlock(Location location, @NotNull String name) {
        ItemHolderBlock.getStack(location, name).ifPresent(stack -> location.getWorld().dropItem(location, stack));
    }

    public boolean onInsert(@NotNull Location var1, @NotNull String var2, @NotNull ItemStack var3, @NotNull Player var4);

    public Optional<ItemStack> onRemove(@NotNull Location var1, @NotNull String var2, @NotNull ItemStack var3);
}

