/*
 * Decompiled with CFR 0.152.
 */
package org.metamechanists.quaptics.implementation.attachments;

import dev.sefiraat.sefilib.entity.display.builders.ItemDisplayBuilder;
import dev.sefiraat.sefilib.misc.TransformationBuilder;
import io.github.bakedlibs.dough.blocks.BlockPosition;
import io.github.thebusybiscuit.slimefun4.api.items.SlimefunItem;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.UUID;
import org.bukkit.Color;
import org.bukkit.Location;
import org.bukkit.block.Block;
import org.bukkit.entity.Display;
import org.bukkit.entity.Interaction;
import org.bukkit.entity.ItemDisplay;
import org.bukkit.entity.Player;
import org.bukkit.inventory.ItemStack;
import org.bukkit.util.Transformation;
import org.bukkit.util.Vector;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Unmodifiable;
import org.metamechanists.quaptics.displaymodellib.builders.InteractionBuilder;
import org.metamechanists.quaptics.implementation.tools.multiblockwand.MultiblockWand;
import org.metamechanists.quaptics.storage.PersistentDataTraverser;
import org.metamechanists.quaptics.utils.BlockStorageAPI;
import org.metamechanists.quaptics.utils.Language;
import org.metamechanists.quaptics.utils.id.simple.ItemDisplayId;

@FunctionalInterface
public interface ComplexMultiblock {
    public static final Map<BlockPosition, ItemDisplayId> CACHE = new HashMap<BlockPosition, ItemDisplayId>();
    public static final Color EMPTY_COLOR = Color.fromARGB((int)255, (int)255, (int)255, (int)0);
    public static final Color WRONG_MATERIAL_COLOR = Color.fromARGB((int)255, (int)255, (int)0, (int)0);
    public static final Color RIGHT_MATERIAL_COLOR = Color.fromARGB((int)255, (int)0, (int)255, (int)0);
    public static final Display.Brightness DISPLAY_BRIGHTNESS = new Display.Brightness(15, 15);
    public static final float DISPLAY_SIZE = 0.75f;
    public static final Transformation TRANSFORMATION = new TransformationBuilder().scale(0.75f, 0.75f, 0.75f).build();
    public static final ItemDisplayBuilder GHOST_BLOCK_DISPLAY = (ItemDisplayBuilder)((ItemDisplayBuilder)new ItemDisplayBuilder().setTransformation(TRANSFORMATION)).setBrightness(DISPLAY_BRIGHTNESS);

    private static boolean isStructureBlockValid(@NotNull Block center, @NotNull Vector offset, ItemStack predicted) {
        Block actual = center.getRelative(offset.getBlockX(), offset.getBlockY(), offset.getBlockZ());
        return ComplexMultiblock.isStructureBlockValid(actual, predicted);
    }

    private static boolean isStructureBlockValid(@NotNull Block actual, ItemStack predicted) {
        SlimefunItem predictedSlimefunItem = SlimefunItem.getByItem((ItemStack)predicted);
        SlimefunItem actualSlimefunItem = BlockStorageAPI.check(actual);
        if (actualSlimefunItem != null) {
            return predictedSlimefunItem != null && predictedSlimefunItem.getId().equals(actualSlimefunItem.getId());
        }
        return predicted.getType() == actual.getType();
    }

    default public boolean isStructureValid(Block center) {
        return this.getStructure().entrySet().stream().allMatch(entry -> ComplexMultiblock.isStructureBlockValid(center, (Vector)entry.getKey(), (ItemStack)entry.getValue()));
    }

    @NotNull
    private static @Unmodifiable List<UUID> projectBlock(@NotNull Block center, @NotNull Vector offset, @NotNull ItemStack stack) {
        Block block = center.getRelative(offset.getBlockX(), offset.getBlockY(), offset.getBlockZ());
        if (block.getType().isEmpty()) {
            GHOST_BLOCK_DISPLAY.setGlowColorOverride(EMPTY_COLOR);
        } else {
            GHOST_BLOCK_DISPLAY.setGlowColorOverride(ComplexMultiblock.isStructureBlockValid(block, stack) ? RIGHT_MATERIAL_COLOR : WRONG_MATERIAL_COLOR);
        }
        ItemDisplay itemDisplay = ((ItemDisplayBuilder)GHOST_BLOCK_DISPLAY.setItemStack(new ItemStack(stack)).setLocation(block.getLocation().toCenterLocation())).build();
        itemDisplay.setGlowing(true);
        Interaction interaction = new InteractionBuilder().width(0.75f).height(0.75f).build(block.getLocation().toCenterLocation());
        CACHE.put(new BlockPosition(block), new ItemDisplayId(itemDisplay.getUniqueId()));
        PersistentDataTraverser traverser = new PersistentDataTraverser(interaction.getUniqueId());
        traverser.set("linked_block", new ItemDisplayId(itemDisplay.getUniqueId()));
        return List.of(itemDisplay.getUniqueId(), interaction.getUniqueId());
    }

    default public void visualiseStructure(ItemStack wand, Block center) {
        ArrayList<UUID> uuids = new ArrayList<UUID>();
        this.getStructure().forEach((key, value) -> uuids.addAll(ComplexMultiblock.projectBlock(center, key, value)));
        PersistentDataTraverser traverser = new PersistentDataTraverser(wand);
        traverser.set("uuids", uuids);
        traverser.save(wand);
    }

    default public void multiblockInteract(Block center, Player player, ItemStack stack) {
        MultiblockWand.updateLore(stack);
        if (this.isStructureValid(center)) {
            Language.sendLanguageMessage(player, "multiblock.valid", new Object[0]);
            return;
        }
        MultiblockWand.removeProjection(stack);
        this.visualiseStructure(stack, center);
    }

    default public boolean multiblockInteract(Block center, @NotNull Player player) {
        ItemStack mainHandItem = player.getInventory().getItemInMainHand();
        ItemStack offHandItem = player.getInventory().getItemInOffHand();
        if (SlimefunItem.getByItem((ItemStack)mainHandItem) instanceof MultiblockWand) {
            this.multiblockInteract(center, player, mainHandItem);
            return true;
        }
        if (SlimefunItem.getByItem((ItemStack)offHandItem) instanceof MultiblockWand) {
            this.multiblockInteract(center, player, offHandItem);
            return true;
        }
        return false;
    }

    default public void tickAnimation(@NotNull Location centerLocation, double timeSeconds) {
    }

    public Map<Vector, ItemStack> getStructure();
}

