/*
 * Decompiled with CFR 0.152.
 */
package org.metamechanists.quaptics.beams;

import java.util.Collection;
import java.util.concurrent.ConcurrentLinkedQueue;
import org.jetbrains.annotations.NotNull;
import org.metamechanists.quaptics.beams.beam.Beam;

public final class DeprecatedBeamStorage {
    private static final Collection<Beam> beams = new ConcurrentLinkedQueue<Beam>();

    private DeprecatedBeamStorage() {
    }

    public static void deprecate(Beam beam) {
        beams.add(beam);
    }

    public static void tick() {
        beams.forEach(Beam::tick);
        beams.stream().filter(Beam::expired).forEach(DeprecatedBeamStorage::remove);
    }

    public static void remove(@NotNull Beam beam) {
        beam.remove();
        beams.remove(beam);
    }
}

