/*
 * Decompiled with CFR 0.152.
 */
package org.metamechanists.quaptics.utils.id;

import java.util.UUID;
import org.jetbrains.annotations.NotNull;

public abstract class CustomId {
    private final UUID uuid;

    protected CustomId() {
        this.uuid = UUID.randomUUID();
    }

    protected CustomId(String uuid) {
        this.uuid = UUID.fromString(uuid);
    }

    protected CustomId(@NotNull CustomId id) {
        this.uuid = id.uuid;
    }

    protected CustomId(UUID uuid) {
        this.uuid = uuid;
    }

    public abstract Object get();

    public UUID getUUID() {
        return this.uuid;
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public boolean equals(Object obj) {
        if (this == obj) return true;
        if (!(obj instanceof CustomId)) return false;
        CustomId customId = (CustomId)obj;
        if (!this.uuid.equals(customId.uuid)) return false;
        return true;
    }

    public int hashCode() {
        return this.uuid.hashCode();
    }

    public String toString() {
        return this.uuid.toString();
    }
}

