/*
 * Decompiled with CFR 0.152.
 */
package org.metamechanists.quaptics.panels.info.implementation;

import java.util.Optional;
import org.bukkit.Location;
import org.bukkit.inventory.ItemStack;
import org.jetbrains.annotations.NotNull;
import org.metamechanists.quaptics.connections.ConnectionGroup;
import org.metamechanists.quaptics.implementation.attachments.ItemHolderBlock;
import org.metamechanists.quaptics.implementation.tools.QuapticChargeableItem;
import org.metamechanists.quaptics.items.Lore;
import org.metamechanists.quaptics.panels.info.BlockInfoPanel;
import org.metamechanists.quaptics.panels.info.InfoPanelBuilder;
import org.metamechanists.quaptics.panels.info.InfoPanelContainer;
import org.metamechanists.quaptics.utils.id.complex.ConnectionGroupId;
import org.metamechanists.quaptics.utils.id.complex.InfoPanelId;

public class ChargerInfoPanel
extends BlockInfoPanel {
    public ChargerInfoPanel(@NotNull Location location, ConnectionGroupId groupId) {
        super(location, groupId);
    }

    public ChargerInfoPanel(@NotNull InfoPanelId panelId, ConnectionGroupId groupId) {
        super(panelId, groupId);
    }

    @Override
    protected InfoPanelContainer buildPanelContainer(@NotNull Location location) {
        return new InfoPanelBuilder(location.clone().toCenterLocation().add(this.getOffset()), 0.4f).addAttribute("chargeText", false).addAttribute("chargeBar", false).build();
    }

    @Override
    public void update() {
        if (this.isPanelHidden()) {
            return;
        }
        Optional<ConnectionGroup> group = this.getGroup();
        if (group.isEmpty()) {
            return;
        }
        Optional<ItemStack> stack = ItemHolderBlock.getStack(group.get(), "item");
        if (stack.isEmpty()) {
            return;
        }
        double capacity = QuapticChargeableItem.getCapacity(stack.get());
        double charge = QuapticChargeableItem.getCharge(stack.get());
        this.container.setText("chargeText", Lore.chargeBarRaw((int)charge, (int)capacity));
        this.container.setText("chargeBar", Lore.chargeValuesRaw((int)charge, (int)capacity));
    }
}

