/*
 * Decompiled with CFR 0.152.
 */
package org.metamechanists.quaptics.panels.info;

import java.util.LinkedHashMap;
import java.util.Map;
import org.bukkit.Location;
import org.bukkit.util.Vector;
import org.joml.Vector3f;
import org.metamechanists.quaptics.panels.info.InfoPanelAttribute;
import org.metamechanists.quaptics.panels.info.InfoPanelContainer;
import org.metamechanists.quaptics.utils.id.complex.InfoPanelAttributeId;

public class InfoPanelBuilder {
    private final Vector3f displaySize;
    private final Vector attributeSpacing;
    private final Location location;
    private final Map<String, InfoPanelAttributeId> attributes = new LinkedHashMap<String, InfoPanelAttributeId>();

    public InfoPanelBuilder(Location location, float size) {
        this.displaySize = new Vector3f(size, size, size);
        this.attributeSpacing = new Vector(0.0, (double)size / 3.5, 0.0);
        this.location = location;
    }

    public InfoPanelBuilder addAttribute(String name, boolean hidden) {
        InfoPanelAttribute attribute = new InfoPanelAttribute(this.location.clone(), this.displaySize);
        attribute.setHidden(hidden);
        this.attributes.put(name, attribute.getId());
        return this;
    }

    public InfoPanelContainer build() {
        return new InfoPanelContainer(this.location, this.attributeSpacing, this.attributes);
    }
}

