/*
 * Decompiled with CFR 0.152.
 */
package org.metamechanists.quaptics.metalib.dough.protection.modules;

import java.util.UUID;
import javax.annotation.Nonnull;
import me.william278.husktowns.HuskTownsAPI;
import me.william278.husktowns.listener.ActionType;
import org.bukkit.Location;
import org.bukkit.OfflinePlayer;
import org.bukkit.plugin.Plugin;
import org.metamechanists.quaptics.metalib.dough.protection.Interaction;
import org.metamechanists.quaptics.metalib.dough.protection.ProtectionModule;

public class HuskTownsProtectionModule
implements ProtectionModule {
    private HuskTownsAPI huskTownsAPI;
    private final Plugin plugin;

    public HuskTownsProtectionModule(@Nonnull Plugin plugin) {
        this.plugin = plugin;
    }

    @Override
    public void load() {
        this.huskTownsAPI = HuskTownsAPI.getInstance();
    }

    @Override
    public Plugin getPlugin() {
        return this.plugin;
    }

    @Override
    public boolean hasPermission(OfflinePlayer p, Location l, Interaction action) {
        UUID playerUUID = p.getUniqueId();
        return this.huskTownsAPI.canPerformAction(playerUUID, l, this.getHuskTownsAction(action));
    }

    @Nonnull
    public ActionType getHuskTownsAction(@Nonnull Interaction doughAction) {
        switch (doughAction) {
            case BREAK_BLOCK: {
                return ActionType.BREAK_BLOCK;
            }
            case PLACE_BLOCK: {
                return ActionType.PLACE_BLOCK;
            }
            case ATTACK_ENTITY: {
                return ActionType.PVE;
            }
            case ATTACK_PLAYER: {
                return ActionType.PVP;
            }
            case INTERACT_BLOCK: {
                return ActionType.INTERACT_BLOCKS;
            }
        }
        return ActionType.ENTITY_INTERACTION;
    }
}

