/*
 * Decompiled with CFR 0.152.
 */
package org.metamechanists.quaptics.implementation.tools.raygun;

import io.github.thebusybiscuit.slimefun4.api.events.PlayerRightClickEvent;
import io.github.thebusybiscuit.slimefun4.api.items.ItemGroup;
import io.github.thebusybiscuit.slimefun4.api.items.SlimefunItemStack;
import io.github.thebusybiscuit.slimefun4.api.recipes.RecipeType;
import org.bukkit.Location;
import org.bukkit.entity.Player;
import org.bukkit.inventory.EquipmentSlot;
import org.bukkit.inventory.ItemStack;
import org.bukkit.inventory.MainHand;
import org.metamechanists.quaptics.implementation.Settings;
import org.metamechanists.quaptics.implementation.tools.QuapticChargeableItem;
import org.metamechanists.quaptics.metalib.utils.LocationUtils;

public abstract class AbstractRayGun
extends QuapticChargeableItem {
    protected AbstractRayGun(ItemGroup itemGroup, SlimefunItemStack item, RecipeType recipeType, ItemStack[] recipe, Settings settings) {
        super(itemGroup, item, recipeType, recipe, settings);
    }

    @Override
    public void onUseItem(PlayerRightClickEvent event) {
        ItemStack itemStack = event.getItem();
        double charge = AbstractRayGun.getCharge(itemStack);
        if (charge < this.settings.getOutputPower()) {
            return;
        }
        Player player = event.getPlayer();
        boolean leftHand = player.getMainHand() == MainHand.LEFT && event.getHand() == EquipmentSlot.HAND || player.getMainHand() == MainHand.RIGHT && event.getHand() == EquipmentSlot.OFF_HAND;
        Location eyeLocation = player.getEyeLocation();
        Location handLocation = LocationUtils.getHandLocation(player, leftHand);
        Location target = eyeLocation.clone().add(eyeLocation.getDirection().multiply(this.settings.getRange()));
        this.fireRayGun(player, eyeLocation, handLocation, target);
        AbstractRayGun.setCharge(itemStack, this.stepCharge(this.settings, charge, -this.settings.getOutputPower()));
        AbstractRayGun.updateLore(itemStack);
    }

    protected abstract void fireRayGun(Player var1, Location var2, Location var3, Location var4);
}

