/*
 * Decompiled with CFR 0.152.
 */
package org.metamechanists.quaptics.implementation.blocks.manipulators;

import io.github.thebusybiscuit.slimefun4.api.items.ItemGroup;
import io.github.thebusybiscuit.slimefun4.api.items.SlimefunItemStack;
import io.github.thebusybiscuit.slimefun4.api.recipes.RecipeType;
import java.util.List;
import java.util.Optional;
import org.bukkit.Location;
import org.bukkit.Material;
import org.bukkit.entity.Player;
import org.bukkit.inventory.ItemStack;
import org.bukkit.util.Vector;
import org.jetbrains.annotations.NotNull;
import org.metamechanists.quaptics.connections.ConnectionGroup;
import org.metamechanists.quaptics.connections.ConnectionPoint;
import org.metamechanists.quaptics.connections.ConnectionPointType;
import org.metamechanists.quaptics.connections.Link;
import org.metamechanists.quaptics.displaymodellib.models.ModelBuilder;
import org.metamechanists.quaptics.displaymodellib.models.components.ModelDiamond;
import org.metamechanists.quaptics.displaymodellib.sefilib.entity.display.DisplayGroup;
import org.metamechanists.quaptics.implementation.Settings;
import org.metamechanists.quaptics.implementation.attachments.PowerAnimatedBlock;
import org.metamechanists.quaptics.implementation.attachments.PowerLossBlock;
import org.metamechanists.quaptics.implementation.base.ConnectedBlock;
import org.metamechanists.quaptics.items.Lore;
import org.metamechanists.quaptics.items.Tier;
import org.metamechanists.quaptics.utils.id.complex.ConnectionGroupId;

public class Lens
extends ConnectedBlock
implements PowerAnimatedBlock,
PowerLossBlock {
    public static final Settings LENS_1_SETTINGS = Settings.builder().tier(Tier.PRIMITIVE).powerLoss(0.1).build();
    public static final Settings LENS_2_SETTINGS = Settings.builder().tier(Tier.BASIC).powerLoss(0.07).build();
    public static final Settings LENS_3_SETTINGS = Settings.builder().tier(Tier.INTERMEDIATE).powerLoss(0.04).build();
    public static final Settings LENS_4_SETTINGS = Settings.builder().tier(Tier.ADVANCED).powerLoss(0.02).build();
    public static final SlimefunItemStack LENS_1 = new SlimefunItemStack("QP_LENS_1", Material.GLASS, "&9Lens &8I", Lore.create(LENS_1_SETTINGS, "&7\u25cf Redirects quaptic rays"));
    public static final SlimefunItemStack LENS_2 = new SlimefunItemStack("QP_LENS_2", Material.GLASS, "&9Lens &8II", Lore.create(LENS_2_SETTINGS, "&7\u25cf Redirects quaptic rays"));
    public static final SlimefunItemStack LENS_3 = new SlimefunItemStack("QP_LENS_3", Material.GLASS, "&9Lens &8III", Lore.create(LENS_3_SETTINGS, "&7\u25cf Redirects quaptic rays"));
    public static final SlimefunItemStack LENS_4 = new SlimefunItemStack("QP_LENS_4", Material.GLASS, "&9Lens &8IV", Lore.create(LENS_4_SETTINGS, "&7\u25cf Redirects quaptic rays"));
    private final Vector inputPointLocation = new Vector(0.0f, 0.0f, -this.getConnectionRadius());
    private final Vector outputPointLocation = new Vector(0.0f, 0.0f, this.getConnectionRadius());

    public Lens(ItemGroup itemGroup, SlimefunItemStack item, RecipeType recipeType, ItemStack[] recipe, Settings settings) {
        super(itemGroup, item, recipeType, recipe, settings);
    }

    @Override
    protected float getConnectionRadius() {
        return 0.4f;
    }

    @Override
    protected DisplayGroup initModel(@NotNull Location location, @NotNull Player player) {
        return new ModelBuilder().add("concrete", new ModelDiamond().material(this.settings.getTier().concreteMaterial).brightness(3).size(0.2f)).add("glass", new ModelDiamond().material(Material.GLASS).size(0.4f)).buildAtBlockCenter(location);
    }

    @Override
    protected List<ConnectionPoint> initConnectionPoints(ConnectionGroupId groupId, Player player, Location location) {
        return List.of(new ConnectionPoint(ConnectionPointType.INPUT, groupId, "input", Lens.formatPointLocation(player, location, this.inputPointLocation)), new ConnectionPoint(ConnectionPointType.OUTPUT, groupId, "output", Lens.formatPointLocation(player, location, this.outputPointLocation)));
    }

    @Override
    public void onInputLinkUpdated(@NotNull ConnectionGroup group, @NotNull Location location) {
        if (this.doBurnoutCheck(group, "input")) {
            return;
        }
        Optional<ConnectionPoint> input = group.getPoint("input");
        if (input.isEmpty()) {
            return;
        }
        this.onPoweredAnimation(location, input.get().isLinkEnabled());
        Optional<Link> outputLink = Lens.getLink(location, "output");
        if (outputLink.isEmpty()) {
            return;
        }
        Optional<Link> inputLink = Lens.getLink(location, "input");
        if (inputLink.isEmpty()) {
            outputLink.get().disable();
            return;
        }
        outputLink.get().setPowerFrequencyPhase(PowerLossBlock.calculatePowerLoss(this.settings, inputLink.get()), inputLink.get().getFrequency(), inputLink.get().getPhase());
    }

    @Override
    public void onPoweredAnimation(@NotNull Location location, boolean powered) {
        this.brightnessAnimation(location, "concrete", powered);
    }
}

