/*
 * Decompiled with CFR 0.152.
 */
package org.metamechanists.quaptics.implementation.attachments;

import java.util.Optional;
import org.bukkit.Location;
import org.jetbrains.annotations.NotNull;
import org.metamechanists.quaptics.connections.ConnectionGroup;
import org.metamechanists.quaptics.items.Lore;
import org.metamechanists.quaptics.utils.BlockStorageAPI;

public interface ProgressBlock {
    public static void setProgress(Location location, double progress) {
        BlockStorageAPI.set(location, "QP_PROGRESS", progress);
    }

    public static double getProgress(Location location) {
        return BlockStorageAPI.getDouble(location, "QP_PROGRESS");
    }

    public static void updateProgress(@NotNull Location location, double tickInterval, double maxTime) {
        double progress = ProgressBlock.getProgress(location);
        progress += tickInterval / 20.0;
        progress = Math.min(progress, maxTime);
        ProgressBlock.setProgress(location, progress);
    }

    public static String progressBar(@NotNull ConnectionGroup group) {
        Optional<Location> location = group.getLocation();
        if (location.isEmpty()) {
            return "&cERROR";
        }
        double progress = ProgressBlock.getProgress(location.get());
        double maxTime = group.getBlock().getSettings().getTimePerItem();
        return Lore.progressBar(progress, maxTime, "&6", "&8", "&a");
    }
}

