/*
 * Decompiled with CFR 0.152.
 */
package org.metamechanists.quaptics.displaymodellib.transformations;

import java.util.ArrayDeque;
import java.util.Deque;
import org.bukkit.Location;
import org.bukkit.block.BlockFace;
import org.jetbrains.annotations.NotNull;
import org.joml.Matrix4f;
import org.joml.Vector3d;
import org.joml.Vector3f;
import org.metamechanists.quaptics.displaymodellib.transformations.components.LookAlong;
import org.metamechanists.quaptics.displaymodellib.transformations.components.Rotation;
import org.metamechanists.quaptics.displaymodellib.transformations.components.Scale;
import org.metamechanists.quaptics.displaymodellib.transformations.components.TransformationMatrixComponent;
import org.metamechanists.quaptics.displaymodellib.transformations.components.Translation;

public class TransformationMatrixBuilder {
    private static final Vector3f BLOCK_DISPLAY_ADJUSTMENT = new Vector3f(-0.5f);
    private final Deque<TransformationMatrixComponent> components = new ArrayDeque<TransformationMatrixComponent>();

    public TransformationMatrixBuilder translate(@NotNull Vector3f translation) {
        this.components.addLast(new Translation(translation));
        return this;
    }

    public TransformationMatrixBuilder translate(float x, float y, float z) {
        this.translate(new Vector3f(x, y, z));
        return this;
    }

    public TransformationMatrixBuilder scale(@NotNull Vector3f scale) {
        this.components.addLast(new Scale(scale));
        return this;
    }

    public TransformationMatrixBuilder scale(float x, float y, float z) {
        this.scale(new Vector3f(x, y, z));
        return this;
    }

    public TransformationMatrixBuilder rotate(@NotNull Vector3d rotation) {
        this.components.addLast(new Rotation(rotation));
        return this;
    }

    public TransformationMatrixBuilder rotate(double x, double y, double z) {
        this.rotate(new Vector3d(x, y, z));
        return this;
    }

    public TransformationMatrixBuilder lookAlong(@NotNull Vector3f direction) {
        this.components.addLast(new LookAlong(direction));
        return this;
    }

    public TransformationMatrixBuilder lookAlong(@NotNull Location from, @NotNull Location to) {
        this.components.addLast(new LookAlong(from, to));
        return this;
    }

    public TransformationMatrixBuilder lookAlong(@NotNull Vector3f from, @NotNull Vector3f to) {
        this.components.addLast(new LookAlong(from, to));
        return this;
    }

    public TransformationMatrixBuilder lookAlong(@NotNull BlockFace face) {
        this.components.addLast(new LookAlong(face.getDirection().toVector3f()));
        return this;
    }

    @NotNull
    private Matrix4f build() {
        Matrix4f matrix = new Matrix4f();
        while (!this.components.isEmpty()) {
            this.components.removeFirst().apply(matrix);
        }
        return matrix;
    }

    @NotNull
    public Matrix4f buildForBlockDisplay() {
        this.components.addLast(new Translation(BLOCK_DISPLAY_ADJUSTMENT));
        return this.build();
    }

    @NotNull
    public Matrix4f buildForItemDisplay() {
        return this.build();
    }

    @NotNull
    public Matrix4f buildForTextDisplay() {
        return this.build();
    }
}

