/*
 * Decompiled with CFR 0.152.
 */
package org.metamechanists.quaptics.displaymodellib.sefilib.slimefun.itemgroup;

import io.github.bakedlibs.dough.chat.ChatInput;
import io.github.thebusybiscuit.slimefun4.api.items.ItemGroup;
import io.github.thebusybiscuit.slimefun4.api.items.groups.FlexItemGroup;
import io.github.thebusybiscuit.slimefun4.api.player.PlayerProfile;
import io.github.thebusybiscuit.slimefun4.core.guide.SlimefunGuide;
import io.github.thebusybiscuit.slimefun4.core.guide.SlimefunGuideMode;
import io.github.thebusybiscuit.slimefun4.implementation.Slimefun;
import io.github.thebusybiscuit.slimefun4.utils.ChestMenuUtils;
import java.util.ArrayList;
import java.util.List;
import javax.annotation.Nonnull;
import javax.annotation.ParametersAreNonnullByDefault;
import me.mrCookieSlime.CSCoreLibPlugin.general.Inventory.ChestMenu;
import org.bukkit.ChatColor;
import org.bukkit.NamespacedKey;
import org.bukkit.Sound;
import org.bukkit.command.CommandSender;
import org.bukkit.entity.Player;
import org.bukkit.inventory.ItemStack;
import org.bukkit.plugin.Plugin;
import org.bukkit.plugin.java.JavaPlugin;
import org.metamechanists.quaptics.displaymodellib.sefilib.slimefun.itemgroup.MenuItem;

public class SimpleFlexGroup
extends FlexItemGroup {
    private static final int PAGE_SIZE = 36;
    private static final int GUIDE_BACK = 1;
    private static final int GUIDE_SEARCH = 7;
    private static final int PAGE_PREVIOUS = 46;
    private static final int PAGE_NEXT = 52;
    private static final int[] HEADER = new int[]{0, 1, 2, 3, 4, 5, 6, 7, 8};
    private static final int[] FOOTER = new int[]{45, 46, 47, 48, 49, 50, 51, 52, 53};
    @Nonnull
    private final JavaPlugin plugin;
    @Nonnull
    private final String name;
    private final List<MenuItem> menuItems = new ArrayList<MenuItem>();

    @ParametersAreNonnullByDefault
    public SimpleFlexGroup(JavaPlugin plugin, String name, NamespacedKey key, ItemStack item) {
        super(key, item);
        this.plugin = plugin;
        this.name = name;
    }

    @ParametersAreNonnullByDefault
    public boolean isVisible(Player player, PlayerProfile playerProfile, SlimefunGuideMode guideMode) {
        return true;
    }

    @ParametersAreNonnullByDefault
    public void open(Player p, PlayerProfile profile, SlimefunGuideMode mode) {
        ChestMenu chestMenu = new ChestMenu(this.name);
        for (int slot : HEADER) {
            chestMenu.addItem(slot, ChestMenuUtils.getBackground(), ChestMenuUtils.getEmptyClickHandler());
        }
        for (int slot : FOOTER) {
            chestMenu.addItem(slot, ChestMenuUtils.getBackground(), ChestMenuUtils.getEmptyClickHandler());
        }
        chestMenu.setEmptySlotsClickable(false);
        this.setupPage(p, profile, mode, chestMenu, 1);
        chestMenu.open(new Player[]{p});
    }

    @ParametersAreNonnullByDefault
    private void setupPage(Player player, PlayerProfile profile, SlimefunGuideMode mode, ChestMenu menu, int page) {
        int amount = this.menuItems.size();
        int totalPages = (int)Math.ceil((double)amount / 36.0);
        int start = (page - 1) * 36;
        int end = Math.min(start + 36, amount);
        List<MenuItem> sublist = this.menuItems.subList(start, end);
        this.reapplyHeader(player, profile, mode, menu);
        this.reapplyFooter(player, profile, mode, menu, page, totalPages);
        menu.addMenuOpeningHandler(p -> p.playSound(p.getLocation(), Sound.ITEM_BOOK_PAGE_TURN, 1.0f, 1.0f));
        for (int i = 0; i < sublist.size(); ++i) {
            MenuItem menuItem = sublist.get(i);
            int slot = 9 + i;
            if (menuItem.getItemGroup() != null) {
                ItemGroup itemGroup = menuItem.getItemGroup();
                menu.replaceExistingItem(slot, itemGroup.getItem(player));
                menu.addMenuClickHandler(slot, (player1, i1, itemStack1, clickAction) -> this.openPage(profile, itemGroup, mode, 1, page));
                continue;
            }
            if (menuItem.getItem() == null || menuItem.getClickHandler() == null) continue;
            menu.replaceExistingItem(slot, menuItem.getItem());
            menu.addMenuClickHandler(slot, menuItem.getClickHandler());
        }
    }

    @ParametersAreNonnullByDefault
    private boolean openPage(PlayerProfile profile, ItemGroup itemGroup, SlimefunGuideMode mode, int page, int returnPage) {
        profile.getGuideHistory().add((ItemGroup)this, returnPage);
        SlimefunGuide.openItemGroup((PlayerProfile)profile, (ItemGroup)itemGroup, (SlimefunGuideMode)mode, (int)page);
        return false;
    }

    public SimpleFlexGroup addItemGroup(@Nonnull ItemGroup itemGroup) {
        this.menuItems.add(MenuItem.of(itemGroup));
        return this;
    }

    public SimpleFlexGroup addMenuItem(@Nonnull MenuItem menuItem) {
        this.menuItems.add(menuItem);
        return this;
    }

    @ParametersAreNonnullByDefault
    private void reapplyFooter(Player p, PlayerProfile profile, SlimefunGuideMode mode, ChestMenu menu, int page, int totalPages) {
        for (int slot2 : FOOTER) {
            menu.replaceExistingItem(slot2, ChestMenuUtils.getBackground());
            menu.addMenuClickHandler(slot2, ChestMenuUtils.getEmptyClickHandler());
        }
        menu.replaceExistingItem(46, ChestMenuUtils.getPreviousButton((Player)p, (int)page, (int)totalPages));
        menu.addMenuClickHandler(46, (player1, slot, itemStack, clickAction) -> {
            int previousPage = page - 1;
            if (previousPage >= 1) {
                this.setupPage(player1, profile, mode, menu, previousPage);
            }
            return false;
        });
        menu.replaceExistingItem(52, ChestMenuUtils.getNextButton((Player)p, (int)page, (int)totalPages));
        menu.addMenuClickHandler(52, (player1, slot, itemStack, clickAction) -> {
            int nextPage = page + 1;
            if (nextPage <= totalPages) {
                this.setupPage(player1, profile, mode, menu, nextPage);
            }
            return false;
        });
    }

    @ParametersAreNonnullByDefault
    private void reapplyHeader(Player player, PlayerProfile profile, SlimefunGuideMode mode, ChestMenu menu) {
        menu.replaceExistingItem(1, ChestMenuUtils.getBackButton((Player)player, (String[])new String[]{"", ChatColor.GRAY + Slimefun.getLocalization().getMessage(player, "guide.back.guide")}));
        menu.addMenuClickHandler(1, (p, slot, itemStack, clickAction) -> {
            SlimefunGuide.openMainMenu((PlayerProfile)profile, (SlimefunGuideMode)mode, (int)profile.getGuideHistory().getMainMenuPage());
            return false;
        });
        menu.replaceExistingItem(7, ChestMenuUtils.getSearchButton((Player)player));
        menu.addMenuClickHandler(7, (p, slot, itemStack, clickAction) -> {
            p.closeInventory();
            Slimefun.getLocalization().sendMessage((CommandSender)p, "guide.search.message");
            ChatInput.waitForPlayer((Plugin)this.plugin, p, msg -> SlimefunGuide.openSearch((PlayerProfile)profile, (String)msg, (SlimefunGuideMode)mode, (boolean)true));
            return false;
        });
    }
}

