/*
 * Decompiled with CFR 0.152.
 */
package org.metamechanists.quaptics.schedulers;

import java.util.Optional;
import java.util.Queue;
import java.util.concurrent.ConcurrentLinkedQueue;
import org.bukkit.Location;
import org.jetbrains.annotations.NotNull;
import org.metamechanists.quaptics.connections.ConnectionGroup;
import org.metamechanists.quaptics.utils.id.complex.ConnectionGroupId;

public final class BlockUpdateScheduler {
    private static Queue<ConnectionGroupId> newGroupsToTick = new ConcurrentLinkedQueue<ConnectionGroupId>();

    private BlockUpdateScheduler() {
    }

    private static void tickGroup(@NotNull ConnectionGroupId groupId) {
        Object connectionGroup = groupId.get();
        if (((Optional)connectionGroup).isEmpty()) {
            return;
        }
        Optional<Location> location = ((ConnectionGroup)((Optional)connectionGroup).get()).getLocation();
        if (location.isEmpty()) {
            return;
        }
        ((Optional)groupId.get()).ifPresent(group -> group.getBlock().onInputLinkUpdated((ConnectionGroup)group, (Location)location.get()));
    }

    public static void scheduleUpdate(ConnectionGroupId groupId) {
        newGroupsToTick.add(groupId);
    }

    public static void tick() {
        Queue<ConnectionGroupId> oldGroupsToTick = newGroupsToTick;
        newGroupsToTick = new ConcurrentLinkedQueue<ConnectionGroupId>();
        while (!oldGroupsToTick.isEmpty()) {
            BlockUpdateScheduler.tickGroup(oldGroupsToTick.remove());
        }
    }
}

