/*
 * Decompiled with CFR 0.152.
 */
package org.metamechanists.quaptics.implementation.multiblocks.beacons.modules.player;

import io.github.thebusybiscuit.slimefun4.api.items.ItemGroup;
import io.github.thebusybiscuit.slimefun4.api.items.SlimefunItem;
import io.github.thebusybiscuit.slimefun4.api.items.SlimefunItemStack;
import io.github.thebusybiscuit.slimefun4.api.recipes.RecipeType;
import java.util.Collection;
import org.bukkit.DyeColor;
import org.bukkit.Location;
import org.bukkit.Material;
import org.bukkit.block.banner.Pattern;
import org.bukkit.block.banner.PatternType;
import org.bukkit.entity.Player;
import org.bukkit.inventory.EquipmentSlot;
import org.bukkit.inventory.ItemFlag;
import org.bukkit.inventory.ItemStack;
import org.bukkit.inventory.meta.BannerMeta;
import org.bukkit.inventory.meta.ItemMeta;
import org.jetbrains.annotations.NotNull;
import org.metamechanists.quaptics.implementation.Settings;
import org.metamechanists.quaptics.implementation.multiblocks.beacons.controllers.BeaconController;
import org.metamechanists.quaptics.implementation.multiblocks.beacons.modules.BeaconModule;
import org.metamechanists.quaptics.implementation.multiblocks.beacons.modules.PlayerModule;
import org.metamechanists.quaptics.implementation.tools.QuapticChargeableItem;
import org.metamechanists.quaptics.items.Lore;
import org.metamechanists.quaptics.items.Tier;
import org.metamechanists.quaptics.utils.BlockStorageAPI;
import org.metamechanists.quaptics.utils.Colors;

public class WirelessChargerModule
extends BeaconModule
implements PlayerModule {
    public static final Settings WIRELESS_CHARGER_MODULE_SETTINGS = Settings.builder().tier(Tier.ADVANCED).operatingPowerHidden(true).powerEfficiency(0.1).build();
    public static final SlimefunItemStack WIRELESS_CHARGER_MODULE = WirelessChargerModule.getBanner(new SlimefunItemStack("QP_WIRELESS_CHARGER_MODULE", Material.ORANGE_BANNER, Colors.BEACONS.getFormattedColor() + "Wireless Charger Module", Lore.create(WIRELESS_CHARGER_MODULE_SETTINGS, "&7\u25cf Wirelessly charges held items", "&7\u25cf The more power the beacon has, the higher the charge rate")));

    public WirelessChargerModule(ItemGroup itemGroup, SlimefunItemStack item, RecipeType recipeType, ItemStack[] recipe, Settings settings) {
        super(itemGroup, item, recipeType, recipe, settings);
    }

    @NotNull
    private static SlimefunItemStack getBanner(@NotNull SlimefunItemStack stack) {
        BannerMeta meta = (BannerMeta)stack.getItemMeta();
        meta.addPattern(new Pattern(DyeColor.LIGHT_BLUE, PatternType.CIRCLE_MIDDLE));
        meta.addPattern(new Pattern(DyeColor.CYAN, PatternType.FLOWER));
        meta.addItemFlags(new ItemFlag[]{ItemFlag.HIDE_ITEM_SPECIFICS});
        stack.setItemMeta((ItemMeta)meta);
        return stack;
    }

    @Override
    public void apply(@NotNull BeaconController controller, @NotNull Location controllerLocation, @NotNull Collection<Player> players) {
        double chargeRate = BlockStorageAPI.getDouble(controllerLocation.clone().add(controller.getPowerSupplyLocation()), "QP_INPUT_POWER");
        players.forEach(player -> {
            SlimefunItem patt3855$temp;
            QuapticChargeableItem chargeableItem;
            ItemStack mainHandItem = player.getInventory().getItem(EquipmentSlot.HAND);
            ItemStack offHandItem = player.getInventory().getItem(EquipmentSlot.OFF_HAND);
            SlimefunItem patt3565$temp = SlimefunItem.getByItem((ItemStack)mainHandItem);
            if (patt3565$temp instanceof QuapticChargeableItem) {
                chargeableItem = (QuapticChargeableItem)patt3565$temp;
                chargeableItem.chargeItem(chargeRate, mainHandItem, 22);
                QuapticChargeableItem.updateLore(mainHandItem);
            }
            if ((patt3855$temp = SlimefunItem.getByItem((ItemStack)offHandItem)) instanceof QuapticChargeableItem) {
                chargeableItem = (QuapticChargeableItem)patt3855$temp;
                chargeableItem.chargeItem(chargeRate, offHandItem, 22);
                QuapticChargeableItem.updateLore(offHandItem);
            }
        });
    }
}

