/*
 * Decompiled with CFR 0.152.
 */
package org.metamechanists.quaptics.implementation.blocks.concentrators;

import io.github.thebusybiscuit.slimefun4.api.items.ItemGroup;
import io.github.thebusybiscuit.slimefun4.api.items.SlimefunItemStack;
import io.github.thebusybiscuit.slimefun4.api.recipes.RecipeType;
import java.util.List;
import java.util.Optional;
import org.bukkit.Location;
import org.bukkit.Material;
import org.bukkit.entity.Player;
import org.bukkit.inventory.ItemStack;
import org.bukkit.util.Vector;
import org.jetbrains.annotations.NotNull;
import org.metamechanists.quaptics.connections.ConnectionGroup;
import org.metamechanists.quaptics.connections.ConnectionPoint;
import org.metamechanists.quaptics.connections.ConnectionPointType;
import org.metamechanists.quaptics.connections.Link;
import org.metamechanists.quaptics.displaymodellib.models.ModelBuilder;
import org.metamechanists.quaptics.displaymodellib.models.components.ModelCuboid;
import org.metamechanists.quaptics.displaymodellib.models.components.ModelItem;
import org.metamechanists.quaptics.displaymodellib.sefilib.entity.display.DisplayGroup;
import org.metamechanists.quaptics.implementation.Settings;
import org.metamechanists.quaptics.implementation.attachments.PowerAnimatedBlock;
import org.metamechanists.quaptics.implementation.base.ConnectedBlock;
import org.metamechanists.quaptics.items.Lore;
import org.metamechanists.quaptics.items.Tier;
import org.metamechanists.quaptics.utils.BlockStorageAPI;
import org.metamechanists.quaptics.utils.id.complex.ConnectionGroupId;

public class SolarConcentrator
extends ConnectedBlock
implements PowerAnimatedBlock {
    public static final Settings SOLAR_CONCENTRATOR_1_SETTINGS = Settings.builder().tier(Tier.PRIMITIVE).operatingPowerHidden(true).outputPower(2.0).build();
    public static final Settings SOLAR_CONCENTRATOR_2_SETTINGS = Settings.builder().tier(Tier.PRIMITIVE).operatingPowerHidden(true).outputPower(8.0).build();
    public static final SlimefunItemStack SOLAR_CONCENTRATOR_1 = new SlimefunItemStack("QP_SOLAR_CONCENTRATOR_1", Material.GLASS_PANE, "&eSolar Concentrator &6I", Lore.create(SOLAR_CONCENTRATOR_1_SETTINGS, "&7\u25cf Concentrates sunlight into a quaptic ray"));
    public static final SlimefunItemStack SOLAR_CONCENTRATOR_2 = new SlimefunItemStack("QP_SOLAR_CONCENTRATOR_2", Material.GLASS_PANE, "&eSolar Concentrator &6II", Lore.create(SOLAR_CONCENTRATOR_2_SETTINGS, "&7\u25cf Concentrates sunlight into a quaptic ray"));
    private final Vector outputLocation = new Vector(0.0f, 0.0f, this.getConnectionRadius());

    public SolarConcentrator(ItemGroup itemGroup, SlimefunItemStack item, RecipeType recipeType, ItemStack[] recipe, Settings settings) {
        super(itemGroup, item, recipeType, recipe, settings);
    }

    @Override
    protected float getConnectionRadius() {
        return 0.6f;
    }

    @Override
    protected DisplayGroup initModel(@NotNull Location location, @NotNull Player player) {
        return new ModelBuilder().add("center", new ModelCuboid().material(this.settings.getTier().concreteMaterial).brightness(3).size(0.2f)).add("panel", new ModelItem().material(Material.GLASS_PANE).rotation(1.5707963267948966, 0.0, 0.7853981633974483).size(0.9f)).buildAtBlockCenter(location);
    }

    @Override
    protected List<ConnectionPoint> initConnectionPoints(ConnectionGroupId groupId, Player player, Location location) {
        return List.of(new ConnectionPoint(ConnectionPointType.OUTPUT, groupId, "output", SolarConcentrator.formatPointLocation(player, location, this.outputLocation)));
    }

    @Override
    public void onTick10(@NotNull ConnectionGroup group, @NotNull Location location) {
        boolean powered = location.getWorld().isDayTime();
        this.onPoweredAnimation(location, powered);
        BlockStorageAPI.set(location, "QP_POWERED", powered);
        Optional<Link> linkOptional = SolarConcentrator.getLink(location, "output");
        linkOptional.ifPresent(link -> link.setPower(powered ? this.settings.getOutputPower() : 0.0));
    }

    @Override
    public void onPoweredAnimation(@NotNull Location location, boolean powered) {
        if (powered != BlockStorageAPI.getBoolean(location, "QP_POWERED")) {
            this.brightnessAnimation(location, "center", powered);
        }
    }
}

