/*
 * Decompiled with CFR 0.152.
 */
package org.metamechanists.quaptics.implementation.base;

import io.github.thebusybiscuit.slimefun4.api.items.ItemGroup;
import io.github.thebusybiscuit.slimefun4.api.items.SlimefunItem;
import io.github.thebusybiscuit.slimefun4.api.items.SlimefunItemStack;
import io.github.thebusybiscuit.slimefun4.api.recipes.RecipeType;
import io.github.thebusybiscuit.slimefun4.core.attributes.EnergyNetComponent;
import io.github.thebusybiscuit.slimefun4.core.networks.energy.EnergyNetComponentType;
import javax.annotation.OverridingMethodsMustInvokeSuper;
import me.mrCookieSlime.CSCoreLibPlugin.Configuration.Config;
import org.bukkit.Location;
import org.bukkit.block.Block;
import org.bukkit.inventory.ItemStack;
import org.jetbrains.annotations.NotNull;
import org.metamechanists.quaptics.implementation.Settings;
import org.metamechanists.quaptics.implementation.base.ConnectedBlock;
import org.metamechanists.quaptics.utils.BlockStorageAPI;

public abstract class EnergyConnectedBlock
extends ConnectedBlock
implements EnergyNetComponent {
    private static final EnergyNetComponentType COMPONENT_TYPE = EnergyNetComponentType.CONSUMER;

    protected EnergyConnectedBlock(ItemGroup itemGroup, SlimefunItemStack item, RecipeType recipeType, ItemStack[] recipe, Settings settings) {
        super(itemGroup, item, recipeType, recipe, settings);
    }

    @NotNull
    public EnergyNetComponentType getEnergyComponentType() {
        return COMPONENT_TYPE;
    }

    protected static boolean hasEnoughEnergy(Location location) {
        return BlockStorageAPI.getBoolean(location, "QP_ENOUGH_ENERGY");
    }

    @Override
    @OverridingMethodsMustInvokeSuper
    public void onSlimefunTick(@NotNull Block block, SlimefunItem item, Config data) {
        boolean powered;
        super.onSlimefunTick(block, item, data);
        boolean bl = powered = this.getCharge(block.getLocation(), data) >= this.settings.getEnergyConsumption();
        if (powered) {
            this.removeCharge(block.getLocation(), this.settings.getEnergyConsumption());
        }
        BlockStorageAPI.set(block.getLocation(), "QP_ENOUGH_ENERGY", powered);
    }

    public int getCapacity() {
        return this.settings.getEnergyCapacity();
    }
}

