/*
 * Decompiled with CFR 0.152.
 */
package org.metamechanists.quaptics.utils;

import io.github.thebusybiscuit.slimefun4.api.items.SlimefunItem;
import java.util.Objects;
import java.util.Optional;
import java.util.UUID;
import java.util.stream.Stream;
import me.mrCookieSlime.Slimefun.api.BlockStorage;
import org.bukkit.Location;
import org.bukkit.block.Block;
import org.bukkit.block.BlockFace;
import org.bukkit.util.Vector;
import org.jetbrains.annotations.Nullable;
import org.metamechanists.quaptics.utils.id.CustomId;
import org.metamechanists.quaptics.utils.id.complex.ConfigPanelId;
import org.metamechanists.quaptics.utils.id.complex.InfoPanelId;
import org.metamechanists.quaptics.utils.id.simple.DisplayGroupId;

public final class BlockStorageAPI {
    @Nullable
    public static SlimefunItem check(Location location) {
        return BlockStorage.check((Location)location);
    }

    @Nullable
    public static SlimefunItem check(Block block) {
        return BlockStorage.check((Block)block);
    }

    public static void removeData(Location location) {
        BlockStorage.clearBlockInfo((Location)location);
    }

    private static void removeData(Location location, String key) {
        BlockStorage.addBlockInfo((Location)location, (String)key, null);
    }

    public static boolean hasData(Location location) {
        return BlockStorage.hasBlockInfo((Location)location);
    }

    public static boolean hasData(Location location, String key) {
        return BlockStorageAPI.hasData(location) && BlockStorageAPI.getString(location, key) != null;
    }

    private static void set(Location location, String key, String value) {
        BlockStorage.addBlockInfo((Location)location, (String)key, (String)value);
    }

    public static void set(Location location, String key, boolean value) {
        BlockStorageAPI.set(location, key, Objects.toString(value));
    }

    public static void set(Location location, String key, int value) {
        BlockStorageAPI.set(location, key, Objects.toString(value));
    }

    public static void set(Location location, String key, double value) {
        BlockStorageAPI.set(location, key, Objects.toString(value));
    }

    public static void set(Location location, String key, BlockFace face) {
        BlockStorageAPI.set(location, key, Objects.toString(face));
    }

    public static void set(Location location, String key, @Nullable Vector value) {
        if (value == null) {
            BlockStorageAPI.removeData(location, key + "x");
            BlockStorageAPI.removeData(location, key + "y");
            BlockStorageAPI.removeData(location, key + "z");
            return;
        }
        BlockStorageAPI.set(location, key + "x", value.getX());
        BlockStorageAPI.set(location, key + "y", value.getY());
        BlockStorageAPI.set(location, key + "z", value.getZ());
    }

    public static void set(Location location, String key, @Nullable UUID value) {
        if (value == null) {
            BlockStorageAPI.removeData(location, key);
            return;
        }
        BlockStorageAPI.set(location, key, value.toString());
    }

    public static void set(Location location, String key, @Nullable CustomId value) {
        if (value == null) {
            BlockStorageAPI.removeData(location, key);
            return;
        }
        BlockStorageAPI.set(location, key, value.toString());
    }

    private static String getString(Location location, String key) {
        return BlockStorage.getLocationInfo((Location)location, (String)key);
    }

    public static boolean getBoolean(Location location, String key) {
        return "true".equals(BlockStorageAPI.getString(location, key));
    }

    public static int getInt(Location location, String key) {
        return BlockStorageAPI.hasData(location, key) ? Integer.parseInt(BlockStorageAPI.getString(location, key)) : 0;
    }

    public static double getDouble(Location location, String key) {
        return BlockStorageAPI.hasData(location, key) ? Double.parseDouble(BlockStorageAPI.getString(location, key)) : 0.0;
    }

    public static Optional<Vector> getVector(Location location, String key) {
        return Stream.of("x", "y", "z").allMatch(uuid -> BlockStorageAPI.hasData(location, key + uuid)) ? Optional.of(new Vector(BlockStorageAPI.getDouble(location, key + "x"), BlockStorageAPI.getDouble(location, key + "y"), BlockStorageAPI.getDouble(location, key + "z"))) : Optional.empty();
    }

    public static Optional<UUID> getUuid(Location location, String key) {
        return BlockStorageAPI.hasData(location, key) ? Optional.of(UUID.fromString(BlockStorageAPI.getString(location, key))) : Optional.empty();
    }

    public static Optional<BlockFace> getBlockFace(Location location, String key) {
        return BlockStorageAPI.hasData(location, key) ? Optional.of(BlockFace.valueOf((String)BlockStorageAPI.getString(location, key))) : Optional.empty();
    }

    public static Optional<InfoPanelId> getInfoPanelId(Location location, String key) {
        return BlockStorageAPI.hasData(location, key) ? Optional.of(new InfoPanelId(BlockStorageAPI.getString(location, key))) : Optional.empty();
    }

    public static Optional<ConfigPanelId> getConfigPanelId(Location location, String key) {
        return BlockStorageAPI.hasData(location, key) ? Optional.of(new ConfigPanelId(BlockStorageAPI.getString(location, key))) : Optional.empty();
    }

    public static Optional<DisplayGroupId> getDisplayGroupId(Location location, String key) {
        return BlockStorageAPI.hasData(location, key) ? Optional.of(new DisplayGroupId(BlockStorageAPI.getString(location, key))) : Optional.empty();
    }

    private BlockStorageAPI() {
        throw new UnsupportedOperationException("This is a utility class and cannot be instantiated");
    }
}

