/*
 * Decompiled with CFR 0.152.
 */
package org.metamechanists.quaptics.storage;

import java.util.Collection;
import java.util.HashSet;
import java.util.Set;
import java.util.stream.Collectors;
import org.bukkit.entity.Entity;
import org.bukkit.entity.Interaction;
import org.bukkit.event.EventHandler;
import org.bukkit.event.Listener;
import org.bukkit.event.world.EntitiesLoadEvent;
import org.bukkit.event.world.EntitiesUnloadEvent;
import org.bukkit.persistence.PersistentDataHolder;
import org.jetbrains.annotations.NotNull;
import org.metamechanists.quaptics.storage.PersistentDataTraverser;
import org.metamechanists.quaptics.utils.id.complex.ConnectionGroupId;

public class QuapticStorage
implements Listener {
    private static final Set<ConnectionGroupId> tickingGroupIds = new HashSet<ConnectionGroupId>();

    private static boolean isTickingGroup(Interaction interaction) {
        return new PersistentDataTraverser((PersistentDataHolder)interaction).getBoolean("isTicker");
    }

    public static void addGroup(ConnectionGroupId groupId) {
        tickingGroupIds.add(groupId);
    }

    public static void removeGroup(ConnectionGroupId groupId) {
        tickingGroupIds.remove(groupId);
    }

    @NotNull
    private static Collection<ConnectionGroupId> getTickingGroupIds(@NotNull Collection<Entity> entities) {
        return entities.stream().filter(entity -> entity instanceof Interaction).map(entity -> (Interaction)entity).filter(QuapticStorage::isTickingGroup).map(interaction -> new ConnectionGroupId(interaction.getUniqueId())).collect(Collectors.toList());
    }

    @EventHandler
    public static void onEntityLoad(@NotNull EntitiesLoadEvent event) {
        tickingGroupIds.addAll(QuapticStorage.getTickingGroupIds(event.getEntities()));
    }

    @EventHandler
    public static void onEntityUnload(@NotNull EntitiesUnloadEvent event) {
        tickingGroupIds.removeAll(QuapticStorage.getTickingGroupIds(event.getEntities()));
    }

    public static Set<ConnectionGroupId> getTickingGroupIds() {
        return tickingGroupIds;
    }
}

