/*
 * Decompiled with CFR 0.152.
 */
package org.metamechanists.quaptics.panels.info;

import java.util.Optional;
import org.bukkit.Location;
import org.bukkit.util.Vector;
import org.jetbrains.annotations.NotNull;
import org.metamechanists.quaptics.panels.info.InfoPanelContainer;
import org.metamechanists.quaptics.utils.id.complex.InfoPanelId;

public abstract class InfoPanel {
    protected final InfoPanelContainer container;

    protected InfoPanel(@NotNull Location location) {
        this.container = this.buildPanelContainer(location);
    }

    protected InfoPanel(@NotNull InfoPanelId panelId) {
        this.container = (InfoPanelContainer)((Optional)panelId.get()).get();
    }

    public InfoPanelId getId() {
        return this.container.getId();
    }

    public void changeLocation(@NotNull Location location) {
        this.container.changeLocation(location.clone().add(this.getOffset()));
    }

    public boolean isPanelHidden() {
        return this.container.isHidden();
    }

    public void setPanelHidden(boolean hidden) {
        if (this.container.isHidden() != hidden) {
            this.container.setHidden(hidden);
            this.update();
        }
    }

    public void togglePanelHidden() {
        this.container.toggleHidden();
        this.update();
    }

    public void remove() {
        this.container.remove();
    }

    protected abstract Vector getOffset();

    protected abstract InfoPanelContainer buildPanelContainer(@NotNull Location var1);

    public abstract void update();
}

