/*
 * Decompiled with CFR 0.152.
 */
package org.metamechanists.quaptics.metalib.sefilib.slimefun.recipes;

import io.github.thebusybiscuit.slimefun4.api.SlimefunAddon;
import java.io.File;
import java.util.HashSet;
import java.util.Set;
import javax.annotation.Nonnull;
import javax.annotation.ParametersAreNonnullByDefault;
import org.metamechanists.quaptics.metalib.sefilib.slimefun.recipes.ConfigurableRecipe;
import org.metamechanists.quaptics.metalib.sefilib.slimefun.recipes.ConfigurableRecipeItem;

public class ConfigurableRecipeManager {
    @Nonnull
    private final SlimefunAddon addon;
    @Nonnull
    private final File recipeDirectory;
    @Nonnull
    private final Set<ConfigurableRecipe> recipes = new HashSet<ConfigurableRecipe>();

    public ConfigurableRecipeManager(@Nonnull SlimefunAddon addon) {
        this.addon = addon;
        this.recipeDirectory = new File(this.addon.getJavaPlugin().getDataFolder() + "\\recipes");
        this.recipeDirectory.mkdir();
    }

    @ParametersAreNonnullByDefault
    public void newRecipe(String recipeName, ConfigurableRecipeItem[] defaultItemStacks) {
        ConfigurableRecipe recipe = new ConfigurableRecipe(recipeName, defaultItemStacks);
        this.recipes.add(recipe);
    }

    @Nonnull
    public File getRecipeDirectory() {
        return this.recipeDirectory;
    }

    @Nonnull
    public SlimefunAddon getAddon() {
        return this.addon;
    }

    @Nonnull
    public Set<ConfigurableRecipe> getRecipes() {
        return this.recipes;
    }
}

