/*
 * Decompiled with CFR 0.152.
 */
package org.metamechanists.quaptics.implementation.blocks.concentrators;

import io.github.thebusybiscuit.slimefun4.api.items.ItemGroup;
import io.github.thebusybiscuit.slimefun4.api.items.SlimefunItem;
import io.github.thebusybiscuit.slimefun4.api.items.SlimefunItemStack;
import io.github.thebusybiscuit.slimefun4.api.recipes.RecipeType;
import java.util.List;
import java.util.Optional;
import me.mrCookieSlime.CSCoreLibPlugin.Configuration.Config;
import org.bukkit.Location;
import org.bukkit.Material;
import org.bukkit.block.Block;
import org.bukkit.entity.Player;
import org.bukkit.inventory.ItemStack;
import org.bukkit.util.Vector;
import org.jetbrains.annotations.NotNull;
import org.metamechanists.quaptics.connections.ConnectionPoint;
import org.metamechanists.quaptics.connections.ConnectionPointType;
import org.metamechanists.quaptics.connections.Link;
import org.metamechanists.quaptics.displaymodellib.models.ModelBuilder;
import org.metamechanists.quaptics.displaymodellib.models.components.ModelCuboid;
import org.metamechanists.quaptics.displaymodellib.sefilib.entity.display.DisplayGroup;
import org.metamechanists.quaptics.implementation.Settings;
import org.metamechanists.quaptics.implementation.attachments.PowerAnimatedBlock;
import org.metamechanists.quaptics.implementation.base.EnergyConnectedBlock;
import org.metamechanists.quaptics.items.Lore;
import org.metamechanists.quaptics.items.Tier;
import org.metamechanists.quaptics.utils.BlockStorageAPI;
import org.metamechanists.quaptics.utils.id.complex.ConnectionGroupId;

public class EnergyConcentrator
extends EnergyConnectedBlock
implements PowerAnimatedBlock {
    public static final Settings ENERGY_CONCENTRATOR_1_SETTINGS = Settings.builder().tier(Tier.BASIC).operatingPowerHidden(true).outputPower(30.0).energyConsumption(120).energyCapacity(240).build();
    public static final Settings ENERGY_CONCENTRATOR_2_SETTINGS = Settings.builder().tier(Tier.BASIC).operatingPowerHidden(true).outputPower(70.0).energyConsumption(200).energyCapacity(400).build();
    public static final Settings ENERGY_CONCENTRATOR_3_SETTINGS = Settings.builder().tier(Tier.INTERMEDIATE).operatingPowerHidden(true).outputPower(400.0).energyConsumption(580).energyCapacity(1160).build();
    public static final Settings ENERGY_CONCENTRATOR_4_SETTINGS = Settings.builder().tier(Tier.INTERMEDIATE).operatingPowerHidden(true).outputPower(800.0).energyConsumption(950).energyCapacity(1900).build();
    public static final SlimefunItemStack ENERGY_CONCENTRATOR_1 = new SlimefunItemStack("QP_ENERGY_CONCENTRATOR_1", Material.GRAY_CONCRETE, "&eEnergy Concentrator &6I", Lore.create(ENERGY_CONCENTRATOR_1_SETTINGS, "&7\u25cf Concentrates energy into a quaptic ray"));
    public static final SlimefunItemStack ENERGY_CONCENTRATOR_2 = new SlimefunItemStack("QP_ENERGY_CONCENTRATOR_2", Material.GRAY_CONCRETE, "&eEnergy Concentrator &6II", Lore.create(ENERGY_CONCENTRATOR_2_SETTINGS, "&7\u25cf Concentrates energy into a quaptic ray"));
    public static final SlimefunItemStack ENERGY_CONCENTRATOR_3 = new SlimefunItemStack("QP_ENERGY_CONCENTRATOR_3", Material.GRAY_CONCRETE, "&eEnergy Concentrator &6III", Lore.create(ENERGY_CONCENTRATOR_3_SETTINGS, "&7\u25cf Concentrates energy into a quaptic ray"));
    public static final SlimefunItemStack ENERGY_CONCENTRATOR_4 = new SlimefunItemStack("QP_ENERGY_CONCENTRATOR_4", Material.GRAY_CONCRETE, "&eEnergy Concentrator &6IV", Lore.create(ENERGY_CONCENTRATOR_4_SETTINGS, "&7\u25cf Concentrates energy into a quaptic ray"));
    private final Vector outputLocation = new Vector(0.0f, 0.0f, this.getConnectionRadius());

    public EnergyConcentrator(ItemGroup itemGroup, SlimefunItemStack item, RecipeType recipeType, ItemStack[] recipe, Settings settings) {
        super(itemGroup, item, recipeType, recipe, settings);
    }

    @Override
    protected float getConnectionRadius() {
        return 0.55f;
    }

    @Override
    protected DisplayGroup initModel(@NotNull Location location, @NotNull Player player) {
        return new ModelBuilder().add("center", new ModelCuboid().material(this.settings.getTier().concreteMaterial).brightness(3).size(0.2f)).add("plate", new ModelCuboid().material(Material.GRAY_CONCRETE).rotation(0.7853981633974483).size(0.6f, 0.1f, 0.6f)).add("glass", new ModelCuboid().material(Material.GLASS).rotation(0.7853981633974483).size(0.4f)).buildAtBlockCenter(location);
    }

    @Override
    protected List<ConnectionPoint> initConnectionPoints(ConnectionGroupId groupId, Player player, Location location) {
        return List.of(new ConnectionPoint(ConnectionPointType.OUTPUT, groupId, "output", EnergyConcentrator.formatPointLocation(player, location, this.outputLocation)));
    }

    @Override
    public void onSlimefunTick(@NotNull Block block, SlimefunItem item, Config data) {
        super.onSlimefunTick(block, item, data);
        Location location = block.getLocation();
        boolean powered = EnergyConcentrator.hasEnoughEnergy(location);
        this.onPoweredAnimation(location, powered);
        BlockStorageAPI.set(location, "QP_POWERED", powered);
        Optional<Link> linkOptional = EnergyConcentrator.getLink(location, "output");
        linkOptional.ifPresent(link -> link.setPower(powered ? this.settings.getOutputPower() : 0.0));
    }

    @Override
    public void onPoweredAnimation(@NotNull Location location, boolean powered) {
        if (powered != BlockStorageAPI.getBoolean(location, "QP_POWERED")) {
            this.brightnessAnimation(location, "center", powered);
        }
    }
}

