/*
 * Decompiled with CFR 0.152.
 */
package org.metamechanists.quaptics.implementation.attachments;

import io.github.thebusybiscuit.slimefun4.api.items.SlimefunItem;
import io.github.thebusybiscuit.slimefun4.utils.ChatUtils;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import java.util.UUID;
import org.bukkit.Color;
import org.bukkit.Location;
import org.bukkit.block.Block;
import org.bukkit.entity.BlockDisplay;
import org.bukkit.entity.Interaction;
import org.bukkit.entity.Player;
import org.bukkit.inventory.ItemStack;
import org.bukkit.util.Vector;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Unmodifiable;
import org.metamechanists.quaptics.displaymodellib.builders.InteractionBuilder;
import org.metamechanists.quaptics.displaymodellib.models.components.ModelCuboid;
import org.metamechanists.quaptics.implementation.tools.multiblockwand.MultiblockWand;
import org.metamechanists.quaptics.storage.PersistentDataTraverser;
import org.metamechanists.quaptics.utils.BlockStorageAPI;
import org.metamechanists.quaptics.utils.Language;

@FunctionalInterface
public interface ComplexMultiblock {
    public static final Color EMPTY_COLOR = Color.fromARGB((int)255, (int)255, (int)255, (int)0);
    public static final Color WRONG_MATERIAL_COLOR = Color.fromARGB((int)255, (int)255, (int)0, (int)0);
    public static final Color RIGHT_MATERIAL_COLOR = Color.fromARGB((int)255, (int)0, (int)255, (int)0);
    public static final int DISPLAY_BRIGHTNESS = 15;
    public static final float DISPLAY_SIZE = 0.75f;
    public static final ModelCuboid GHOST_BLOCK_DISPLAY = new ModelCuboid().size(0.75f).brightness(15);

    private static boolean isStructureBlockValid(@NotNull Block center, @NotNull Vector offset, ItemStack predicted) {
        Block actual = center.getRelative(offset.getBlockX(), offset.getBlockY(), offset.getBlockZ());
        return ComplexMultiblock.isStructureBlockValid(actual, predicted);
    }

    private static boolean isStructureBlockValid(@NotNull Block actual, ItemStack predicted) {
        SlimefunItem predictedSlimefunItem = SlimefunItem.getByItem((ItemStack)predicted);
        SlimefunItem actualSlimefunItem = BlockStorageAPI.check(actual);
        if (actualSlimefunItem != null) {
            return predictedSlimefunItem != null && predictedSlimefunItem.getId().equals(actualSlimefunItem.getId());
        }
        return predicted.getType() == actual.getType();
    }

    default public boolean isStructureValid(Block center) {
        return this.getStructure().entrySet().stream().allMatch(entry -> ComplexMultiblock.isStructureBlockValid(center, (Vector)entry.getKey(), (ItemStack)entry.getValue()));
    }

    @NotNull
    private static @Unmodifiable List<UUID> visualiseBlock(@NotNull Block center, @NotNull Vector offset, @NotNull ItemStack itemStack) {
        Block block = center.getRelative(offset.getBlockX(), offset.getBlockY(), offset.getBlockZ());
        if (block.getType().isEmpty()) {
            GHOST_BLOCK_DISPLAY.glow(EMPTY_COLOR);
        } else {
            GHOST_BLOCK_DISPLAY.glow(ComplexMultiblock.isStructureBlockValid(block, itemStack) ? RIGHT_MATERIAL_COLOR : WRONG_MATERIAL_COLOR);
        }
        BlockDisplay blockDisplay = GHOST_BLOCK_DISPLAY.material(itemStack.getType()).build(block.getLocation().toCenterLocation());
        Interaction interaction = new InteractionBuilder().width(0.75f).height(0.75f).build(block.getLocation().toCenterLocation());
        SlimefunItem slimefunItem = SlimefunItem.getByItem((ItemStack)itemStack);
        String blockName = slimefunItem != null ? slimefunItem.getItemName() : ChatUtils.humanize((String)itemStack.getType().name());
        PersistentDataTraverser traverser = new PersistentDataTraverser(interaction.getUniqueId());
        traverser.set("blockName", blockName);
        return List.of(blockDisplay.getUniqueId(), interaction.getUniqueId());
    }

    default public void visualiseStructure(ItemStack wand, Block center) {
        ArrayList<UUID> uuids = new ArrayList<UUID>();
        this.getStructure().forEach((key, value) -> uuids.addAll(ComplexMultiblock.visualiseBlock(center, key, value)));
        PersistentDataTraverser traverser = new PersistentDataTraverser(wand);
        traverser.set("uuids", uuids);
        traverser.save(wand);
    }

    default public void multiblockInteract(Block center, Player player, ItemStack itemStack) {
        if (this.isStructureValid(center)) {
            Language.sendLanguageMessage(player, "multiblock.valid", new Object[0]);
            return;
        }
        MultiblockWand.removeProjection(itemStack);
        this.visualiseStructure(itemStack, center);
    }

    default public boolean multiblockInteract(Block center, @NotNull Player player) {
        ItemStack mainHandItem = player.getInventory().getItemInMainHand();
        ItemStack offHandItem = player.getInventory().getItemInOffHand();
        if (SlimefunItem.getByItem((ItemStack)mainHandItem) instanceof MultiblockWand) {
            this.multiblockInteract(center, player, mainHandItem);
            return true;
        }
        if (SlimefunItem.getByItem((ItemStack)offHandItem) instanceof MultiblockWand) {
            this.multiblockInteract(center, player, offHandItem);
            return true;
        }
        return false;
    }

    default public void tickAnimation(@NotNull Location centerLocation, double timeSeconds) {
    }

    public Map<Vector, ItemStack> getStructure();
}

