/*
 * Decompiled with CFR 0.152.
 */
package org.metamechanists.quaptics.panels.info;

import java.util.Optional;
import net.kyori.adventure.text.Component;
import net.kyori.adventure.text.serializer.legacy.LegacyComponentSerializer;
import org.bukkit.Color;
import org.bukkit.Location;
import org.bukkit.entity.Display;
import org.bukkit.entity.Entity;
import org.bukkit.entity.TextDisplay;
import org.jetbrains.annotations.NotNull;
import org.joml.Vector3f;
import org.metamechanists.quaptics.displaymodellib.builders.TextDisplayBuilder;
import org.metamechanists.quaptics.displaymodellib.transformations.TransformationMatrixBuilder;
import org.metamechanists.quaptics.storage.PersistentDataTraverser;
import org.metamechanists.quaptics.utils.id.complex.InfoPanelAttributeId;
import org.metamechanists.quaptics.utils.id.simple.TextDisplayId;

public class InfoPanelAttribute {
    private static final float HIDDEN_VIEW_RANGE = 0.0f;
    private static final float SHOWN_VIEW_RANGE = 1.0f;
    private final TextDisplayId id;
    private boolean hidden;

    public InfoPanelAttribute(@NotNull Location location, Vector3f displaySize) {
        this.id = new TextDisplayId(new TextDisplayBuilder().transformation(new TransformationMatrixBuilder().scale(displaySize).buildForTextDisplay()).brightness(12).viewRange(0.0f).billboard(Display.Billboard.VERTICAL).backgroundColor(Color.fromARGB((int)0, (int)0, (int)0, (int)0)).build(location).getUniqueId());
        this.hidden = false;
        this.saveData();
    }

    public InfoPanelAttribute(InfoPanelAttributeId id) {
        PersistentDataTraverser traverser = new PersistentDataTraverser(id);
        this.id = new TextDisplayId(id);
        this.hidden = traverser.getBoolean("hidden");
    }

    private void saveData() {
        PersistentDataTraverser traverser = new PersistentDataTraverser(this.id);
        traverser.set("hidden", this.hidden);
    }

    public InfoPanelAttributeId getId() {
        return new InfoPanelAttributeId(this.id);
    }

    public void updateVisibility(boolean panelHidden) {
        this.getTextDisplay().ifPresent(textDisplay -> textDisplay.setViewRange(this.hidden || panelHidden ? 0.0f : 1.0f));
    }

    private Optional<TextDisplay> getTextDisplay() {
        return this.id.get();
    }

    public void changeLocation(Location location) {
        this.getTextDisplay().ifPresent(display -> display.teleport(location.clone()));
    }

    public void setHidden(boolean hidden) {
        if (this.hidden == hidden) {
            return;
        }
        this.hidden = hidden;
        this.saveData();
    }

    public boolean isVisible() {
        return !this.hidden;
    }

    public void setText(@NotNull String text) {
        this.getTextDisplay().ifPresent(display -> display.text((Component)LegacyComponentSerializer.legacyAmpersand().deserialize(text)));
    }

    public void remove() {
        this.getTextDisplay().ifPresent(Entity::remove);
    }
}

