/*
 * Decompiled with CFR 0.152.
 */
package org.metamechanists.quaptics.panels.config;

import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import org.bukkit.Location;
import org.bukkit.entity.Entity;
import org.bukkit.entity.Interaction;
import org.jetbrains.annotations.NotNull;
import org.metamechanists.quaptics.displaymodellib.builders.InteractionBuilder;
import org.metamechanists.quaptics.panels.config.ConfigPanelAttribute;
import org.metamechanists.quaptics.storage.PersistentDataTraverser;
import org.metamechanists.quaptics.utils.id.complex.ConfigPanelAttributeId;
import org.metamechanists.quaptics.utils.id.complex.ConfigPanelId;
import org.metamechanists.quaptics.utils.id.simple.InteractionId;

public class ConfigPanelContainer {
    private final ConfigPanelId id;
    private boolean hidden = true;
    private final Map<String, ? extends ConfigPanelAttributeId> attributes;

    public ConfigPanelContainer(Location location, Map<String, ? extends ConfigPanelAttributeId> attributes) {
        this.id = new ConfigPanelId(new InteractionBuilder().height(0.0f).width(0.0f).build(location).getUniqueId());
        this.attributes = attributes;
        this.saveData();
    }

    public ConfigPanelContainer(@NotNull ConfigPanelId panelId) {
        PersistentDataTraverser traverser = new PersistentDataTraverser(panelId);
        this.id = panelId;
        this.hidden = traverser.getBoolean("hidden");
        this.attributes = traverser.getConfigPanelAttributeIdMap("attributes");
    }

    private void saveData() {
        PersistentDataTraverser traverser = new PersistentDataTraverser(this.id);
        traverser.set("hidden", this.hidden);
        traverser.set("attributes", this.attributes);
    }

    private Optional<Interaction> getInteraction() {
        return new InteractionId(this.id).get();
    }

    private Optional<ConfigPanelAttribute> getAttribute(String name) {
        return this.attributes.get(name).get();
    }

    public void setValue(String name, String value) {
        this.getAttribute(name).ifPresent(attribute -> attribute.setValue(value));
    }

    public void setHidden(boolean hidden) {
        if (this.hidden != hidden) {
            this.hidden = hidden;
            this.updateAttributeVisibility();
            this.saveData();
        }
    }

    private void updateAttributeVisibility() {
        this.attributes.values().stream().map(ConfigPanelAttributeId::get).filter(Objects::nonNull).forEach(attributeOptional -> attributeOptional.ifPresent(attribute -> attribute.setHidden(this.hidden)));
    }

    private void removeAttributes() {
        this.attributes.values().stream().map(ConfigPanelAttributeId::get).filter(Optional::isPresent).map(Optional::get).forEach(ConfigPanelAttribute::remove);
    }

    public void remove() {
        this.removeAttributes();
        this.getInteraction().ifPresent(Entity::remove);
    }

    public ConfigPanelId getId() {
        return this.id;
    }

    public boolean isHidden() {
        return this.hidden;
    }
}

