/*
 * Decompiled with CFR 0.152.
 */
package org.metamechanists.quaptics.panels.config;

import java.util.HashMap;
import java.util.Map;
import org.bukkit.Location;
import org.bukkit.util.Vector;
import org.joml.Vector3d;
import org.metamechanists.quaptics.panels.config.ConfigPanelAttribute;
import org.metamechanists.quaptics.panels.config.ConfigPanelContainer;
import org.metamechanists.quaptics.utils.id.complex.ConfigPanelAttributeId;
import org.metamechanists.quaptics.utils.id.complex.ConnectionGroupId;

public class ConfigPanelBuilder {
    private final ConnectionGroupId groupId;
    private final float size;
    private final Vector3d displayRotation;
    private final Vector attributeSpacing;
    private final Location location;
    private final Vector offset;
    private final Map<String, ConfigPanelAttributeId> attributes = new HashMap<String, ConfigPanelAttributeId>();

    public ConfigPanelBuilder(ConnectionGroupId groupId, Location location, float size, float rotationY) {
        this.groupId = groupId;
        this.size = size;
        this.displayRotation = new Vector3d(0.0, (double)rotationY + Math.PI, 0.0);
        this.attributeSpacing = new Vector(0.0, (double)size / 3.5, 0.0);
        this.location = location;
        this.offset = new Vector();
    }

    public ConfigPanelBuilder addAttribute(String name, String key) {
        ConfigPanelAttribute attribute = new ConfigPanelAttribute(this.groupId, name, key, this.location.clone(), this.offset.clone(), this.displayRotation, this.size);
        this.attributes.put(name, attribute.getId());
        this.offset.add(this.attributeSpacing);
        return this;
    }

    public ConfigPanelContainer build() {
        return new ConfigPanelContainer(this.location, this.attributes);
    }
}

