/*
 * Decompiled with CFR 0.152.
 */
package org.metamechanists.quaptics.metalib.sefilib.slimefun.recipes;

import javax.annotation.Nonnull;
import javax.annotation.ParametersAreNonnullByDefault;
import org.bukkit.configuration.ConfigurationSection;
import org.metamechanists.quaptics.metalib.sefilib.slimefun.recipes.ConfigurableRecipeItem;

public class ConfigurableRecipe {
    @Nonnull
    private final ConfigurableRecipeItem[] defaultRecipe;
    @Nonnull
    private final String recipeName;

    @ParametersAreNonnullByDefault
    public ConfigurableRecipe(String recipeName, ConfigurableRecipeItem[] recipeItems) {
        this.defaultRecipe = recipeItems;
        this.recipeName = recipeName;
    }

    @Nonnull
    public ConfigurableRecipeItem[] getDefaultRecipe() {
        return this.defaultRecipe;
    }

    @Nonnull
    public String getRecipeName() {
        return this.recipeName;
    }

    public static ConfigurableRecipe fromConfig(@Nonnull ConfigurationSection section) {
        ConfigurableRecipeItem[] items = new ConfigurableRecipeItem[9];
        String recipeName = section.getString("name");
        if (recipeName == null) {
            throw new IllegalArgumentException("Recipe name not provided");
        }
        for (int i = 0; i < 9; ++i) {
            ConfigurationSection itemSection = section.getConfigurationSection("item." + i);
            items[i] = itemSection != null ? ConfigurableRecipeItem.fromConfig(itemSection) : ConfigurableRecipeItem.EMPTY;
        }
        return new ConfigurableRecipe(recipeName, items);
    }
}

