/*
 * Decompiled with CFR 0.152.
 */
package org.metamechanists.quaptics.metalib.sefilib.itemstacks;

import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import org.bukkit.Bukkit;
import org.bukkit.entity.Player;
import org.bukkit.event.Event;
import org.bukkit.event.player.PlayerItemBreakEvent;
import org.bukkit.event.player.PlayerItemDamageEvent;
import org.bukkit.inventory.ItemStack;
import org.bukkit.inventory.meta.Damageable;
import org.bukkit.inventory.meta.ItemMeta;

public final class GeneralItemStackUtils {
    private GeneralItemStackUtils() {
        throw new IllegalStateException("Utility class");
    }

    public static void damage(@Nonnull ItemStack itemStack, int amount) {
        GeneralItemStackUtils.damage(itemStack, null, amount);
    }

    public static void damage(@Nonnull ItemStack itemStack, @Nullable Player player, int amount) {
        ItemMeta itemMeta = itemStack.getItemMeta();
        if (itemMeta instanceof Damageable) {
            Damageable damageable = (Damageable)itemMeta;
            int newDamage = Math.max(damageable.getDamage() + amount, 0);
            GeneralItemStackUtils.setItemDamage(itemStack, (ItemMeta)damageable, player, newDamage);
        }
    }

    public static void repair(@Nonnull ItemStack itemStack, int amount) {
        GeneralItemStackUtils.repair(itemStack, null, amount);
    }

    public static void repair(@Nonnull ItemStack itemStack, @Nullable Player player, int amount) {
        ItemMeta itemMeta = itemStack.getItemMeta();
        if (itemMeta instanceof Damageable) {
            Damageable damageable = (Damageable)itemMeta;
            int newDamage = Math.max(damageable.getDamage() - amount, 0);
            GeneralItemStackUtils.setItemDamage(itemStack, (ItemMeta)damageable, player, newDamage);
        }
    }

    public static void setItemDamage(@Nonnull ItemStack itemStack, int amount) {
        GeneralItemStackUtils.setItemDamage(itemStack, null, amount);
    }

    public static void setItemDamage(@Nonnull ItemStack itemStack, @Nullable Player player, int amount) {
        ItemMeta itemMeta = itemStack.getItemMeta();
        GeneralItemStackUtils.setItemDamage(itemStack, itemMeta, player, amount);
    }

    public static void setItemDamage(@Nonnull ItemStack itemStack, @Nonnull ItemMeta itemMeta, @Nullable Player player, int amount) {
        if (!(itemMeta instanceof Damageable)) {
            return;
        }
        Damageable damageable = (Damageable)itemMeta;
        if (amount == damageable.getDamage()) {
            return;
        }
        if (amount >= itemStack.getType().getMaxDurability()) {
            if (player != null) {
                PlayerItemBreakEvent event = new PlayerItemBreakEvent(player, itemStack.clone());
                Bukkit.getPluginManager().callEvent((Event)event);
            }
            itemStack.setAmount(0);
            return;
        }
        if (player != null) {
            int damage = amount - damageable.getDamage();
            PlayerItemDamageEvent event = new PlayerItemDamageEvent(player, itemStack, damage);
            Bukkit.getPluginManager().callEvent((Event)event);
            if (event.isCancelled()) {
                return;
            }
            amount -= damage - event.getDamage();
        }
        damageable.setDamage(amount);
        itemStack.setItemMeta((ItemMeta)damageable);
    }

    @Nonnull
    public static ItemStack getAsQuantity(@Nonnull ItemStack itemStack, int amount) {
        ItemStack clone = itemStack.clone();
        clone.setAmount(amount);
        return clone;
    }
}

