/*
 * Decompiled with CFR 0.152.
 */
package org.metamechanists.quaptics.metalib.external;

import java.lang.reflect.Field;
import java.lang.reflect.Method;
import org.bukkit.Bukkit;
import org.bukkit.FireworkEffect;
import org.bukkit.Location;
import org.bukkit.World;
import org.bukkit.entity.Firework;
import org.bukkit.inventory.meta.FireworkMeta;

public class FireworkUtils {
    private static final byte EVENT_ID_FIREWORK_EXPLOSION = 17;
    private Method M_ENTITY_FIREWORKS__INACTIVE_TICK;
    private Method M_WORLD__BROADCAST_ENTITY_EFFECT;
    private Field F_ENTITY__WORLD;
    private final Field F_CRAFT_ENTITY__HANDLE;
    private final String bukkitVersionString = this.getBukkitVersionString();
    private final String nmsVersionString;
    private final boolean isVersionAfterRefactor;

    public FireworkUtils() throws Exception {
        int minorVersion = this.getMinorVersion(this.bukkitVersionString);
        this.isVersionAfterRefactor = minorVersion >= 17;
        String string = this.nmsVersionString = this.isVersionAfterRefactor ? null : this.getNMSVersionString();
        if (minorVersion >= 18) {
            this.M_ENTITY_FIREWORKS__INACTIVE_TICK = this.locateInactiveTickMethod();
            this.M_ENTITY_FIREWORKS__INACTIVE_TICK.setAccessible(true);
        } else {
            this.M_WORLD__BROADCAST_ENTITY_EFFECT = this.locateBroadcastEntityEffectMethod();
            this.M_WORLD__BROADCAST_ENTITY_EFFECT.setAccessible(true);
            this.F_ENTITY__WORLD = this.locateEntityWorldField();
            this.F_ENTITY__WORLD.setAccessible(true);
        }
        this.F_CRAFT_ENTITY__HANDLE = this.locateBukkitEntityHandleField();
        this.F_CRAFT_ENTITY__HANDLE.setAccessible(true);
    }

    public void playFireworkEffect(Location location, FireworkEffect ... effects) {
        World world = location.getWorld();
        if (world == null) {
            throw new IllegalArgumentException("The provided location has to contain a valid world reference");
        }
        Firework firework = (Firework)world.spawn(location, Firework.class, fireworkBeforeAdd -> {
            FireworkMeta fireworkMeta = fireworkBeforeAdd.getFireworkMeta();
            fireworkMeta.addEffects(effects);
            fireworkBeforeAdd.setFireworkMeta(fireworkMeta);
            fireworkBeforeAdd.detonate();
        });
        try {
            Object nmsEntity = this.F_CRAFT_ENTITY__HANDLE.get(firework);
            if (this.M_ENTITY_FIREWORKS__INACTIVE_TICK != null) {
                this.M_ENTITY_FIREWORKS__INACTIVE_TICK.invoke(nmsEntity, new Object[0]);
            } else {
                Object entityWorld = this.F_ENTITY__WORLD.get(nmsEntity);
                this.M_WORLD__BROADCAST_ENTITY_EFFECT.invoke(entityWorld, nmsEntity, (byte)17);
            }
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        firework.remove();
    }

    private Field locateBukkitEntityHandleField() throws Exception {
        Class<?> entityClass = this.locateEntityClass();
        Class<?> bukkitEntityClass = this.locateBukkitEntityClass();
        Field targetField = this.searchInSelfAndInheritedClasses(bukkitEntityClass, type -> {
            for (Field field : type.getDeclaredFields()) {
                if (field.getType() != entityClass) continue;
                return field;
            }
            return null;
        });
        if (targetField == null) {
            throw new IllegalStateException("Could not locate the entity field within the bukkit entity class");
        }
        return targetField;
    }

    private Field locateEntityWorldField() throws Exception {
        Class<?> worldClass;
        Class<?> entityClass = this.locateEntityClass();
        Field targetField = this.searchInSelfAndInheritedClasses(entityClass, arg_0 -> FireworkUtils.lambda$locateEntityWorldField$2(worldClass = this.locateWorldClass(), arg_0));
        if (targetField == null) {
            throw new IllegalStateException("Could not locate the world field within the entity class");
        }
        return targetField;
    }

    private Method locateInactiveTickMethod() throws Exception {
        Class<?> entityFireworksClass = this.locateEntityFireworksClass();
        Method targetMethod = this.searchInSelfAndInheritedClasses(entityFireworksClass, type -> {
            for (Method method : type.getDeclaredMethods()) {
                if (!method.getName().equals("inactiveTick")) continue;
                return method;
            }
            return null;
        });
        if (targetMethod == null) {
            throw new IllegalStateException("Could not locate the inactiveTick method of the firework entity");
        }
        return targetMethod;
    }

    private Method locateBroadcastEntityEffectMethod() throws Exception {
        Class<?> worldClass = this.locateWorldClass();
        Method targetMethod = this.searchInSelfAndInheritedClasses(worldClass, type -> {
            for (Method method : type.getDeclaredMethods()) {
                if (!method.getName().equals("broadcastEntityEffect")) continue;
                return method;
            }
            return null;
        });
        if (targetMethod == null) {
            throw new IllegalStateException("Could not locate the broadcastEntityEffect method of World");
        }
        return targetMethod;
    }

    private Class<?> locateBukkitEntityClass() throws Exception {
        return Class.forName("org.bukkit.craftbukkit." + this.bukkitVersionString + ".entity.CraftEntity");
    }

    private Class<?> locateEntityClass() throws Exception {
        if (this.isVersionAfterRefactor) {
            return Class.forName("net.minecraft.world.entity.Entity");
        }
        return Class.forName("net.minecraft.server." + this.nmsVersionString + ".Entity");
    }

    private Class<?> locateEntityFireworksClass() throws Exception {
        if (this.isVersionAfterRefactor) {
            return Class.forName("net.minecraft.world.entity.projectile.EntityFireworks");
        }
        return Class.forName("net.minecraft.server." + this.nmsVersionString + ".EntityFireworks");
    }

    private Class<?> locateWorldClass() throws Exception {
        if (this.isVersionAfterRefactor) {
            return Class.forName("net.minecraft.world.level.World");
        }
        return Class.forName("net.minecraft.server." + this.nmsVersionString + ".World");
    }

    private String getBukkitVersionString() {
        String packageName = Bukkit.getServer().getClass().getPackage().getName();
        return packageName.split("\\.")[3];
    }

    private String getNMSVersionString() throws Exception {
        String version = this.searchInSelfAndInheritedClasses(Bukkit.getServer().getClass(), type -> {
            for (Field field : type.getDeclaredFields()) {
                String typeName = field.getType().getSimpleName();
                if (!typeName.equals("DedicatedServer") && !typeName.equals("MinecraftServer")) continue;
                return field.getType().getName().split("\\.")[3];
            }
            return null;
        });
        if (version == null) {
            throw new IllegalStateException("Could not detect the NMS package version");
        }
        return version;
    }

    private int getMinorVersion(String versionString) {
        String[] versionData = versionString.split("_");
        return Integer.parseInt(versionData[1]);
    }

    private <T> T searchInSelfAndInheritedClasses(Class<?> type, FUnsafeFunction<Class<?>, T> consumer) throws Exception {
        while (type != null && type != Object.class) {
            T response = consumer.call(type);
            if (response != null) {
                return response;
            }
            type = type.getSuperclass();
        }
        return null;
    }

    private static /* synthetic */ Field lambda$locateEntityWorldField$2(Class worldClass, Class type) throws Exception {
        for (Field field : type.getDeclaredFields()) {
            if (field.getType() != worldClass) continue;
            return field;
        }
        return null;
    }

    @FunctionalInterface
    public static interface FUnsafeFunction<I, O> {
        public O call(I var1) throws Exception;
    }
}

