/*
 * Decompiled with CFR 0.152.
 */
package org.metamechanists.quaptics.implementation.multiblocks.beacons.controllers;

import io.github.thebusybiscuit.slimefun4.api.items.ItemGroup;
import io.github.thebusybiscuit.slimefun4.api.items.SlimefunItemStack;
import io.github.thebusybiscuit.slimefun4.api.recipes.RecipeType;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.bukkit.Location;
import org.bukkit.Material;
import org.bukkit.entity.Player;
import org.bukkit.inventory.ItemStack;
import org.bukkit.util.Vector;
import org.jetbrains.annotations.NotNull;
import org.joml.Vector3f;
import org.metamechanists.quaptics.displaymodellib.models.ModelBuilder;
import org.metamechanists.quaptics.displaymodellib.models.components.ModelCuboid;
import org.metamechanists.quaptics.displaymodellib.models.components.ModelItem;
import org.metamechanists.quaptics.displaymodellib.sefilib.entity.display.DisplayGroup;
import org.metamechanists.quaptics.implementation.Settings;
import org.metamechanists.quaptics.implementation.multiblocks.beacons.components.BeaconBeam;
import org.metamechanists.quaptics.implementation.multiblocks.beacons.components.BeaconComputer;
import org.metamechanists.quaptics.implementation.multiblocks.beacons.components.BeaconPanel;
import org.metamechanists.quaptics.implementation.multiblocks.beacons.components.BeaconPowerSupply;
import org.metamechanists.quaptics.implementation.multiblocks.beacons.components.BeaconTransmitter;
import org.metamechanists.quaptics.implementation.multiblocks.beacons.controllers.BeaconController;
import org.metamechanists.quaptics.items.Lore;
import org.metamechanists.quaptics.items.Tier;
import org.metamechanists.quaptics.storage.PersistentDataTraverser;
import org.metamechanists.quaptics.utils.id.complex.ConnectionGroupId;
import org.metamechanists.quaptics.utils.id.simple.InteractionId;

public class BeaconController1
extends BeaconController {
    public static final Settings BEACON_CONTROLLER_1_SETTINGS = Settings.builder().tier(Tier.INTERMEDIATE).minPower(700.0).minFrequency(900.0).range(15).build();
    public static final SlimefunItemStack BEACON_CONTROLLER_1 = new SlimefunItemStack("QP_BEACON_CONTROLLER_1", Material.BLUE_CONCRETE, "&dBeacon Controller &5I", Lore.create(BEACON_CONTROLLER_1_SETTINGS, Lore.multiblock(), "&7\u25cf Applies module effects in a range around it", "&7\u25cf &eRight Click &7a module slot with a module to insert"));
    private static final Vector COMPUTER_LOCATION = new Vector(0, 2, 0);
    private static final Vector POWER_SUPPLY_LOCATION = new Vector(0, -1, 0);
    private static final Vector3f MODULE_1_LOCATION = new Vector3f(0.0f, -0.15f, 0.23f);
    private static final Vector3f MODULE_2_LOCATION = new Vector3f(0.0f, -0.15f, -0.23f);

    public BeaconController1(ItemGroup itemGroup, SlimefunItemStack item, RecipeType recipeType, ItemStack[] recipe, Settings settings) {
        super(itemGroup, item, recipeType, recipe, settings);
    }

    @Override
    protected DisplayGroup initModel(@NotNull Location location, @NotNull Player player) {
        DisplayGroup displayGroup = new ModelBuilder().add("main", new ModelCuboid().material(Material.BLUE_CONCRETE).size(0.5f, 1.0f, 0.5f)).add("module1", new ModelItem().item(this.getEmptyItemStack()).brightness(15).size(0.25f).location(MODULE_1_LOCATION).rotation(0.0)).add("module2", new ModelItem().item(this.getEmptyItemStack()).brightness(15).size(0.25f).location(MODULE_2_LOCATION).rotation(Math.PI)).buildAtBlockCenter(location);
        ConnectionGroupId groupId = new ConnectionGroupId(displayGroup.getParentUUID());
        ArrayList<InteractionId> interactionIds = new ArrayList<InteractionId>();
        interactionIds.add(BeaconController1.createButton(groupId, location, MODULE_1_LOCATION, "module1"));
        interactionIds.add(BeaconController1.createButton(groupId, location, MODULE_2_LOCATION, "module2"));
        PersistentDataTraverser traverser = new PersistentDataTraverser(displayGroup.getParentUUID());
        traverser.setCustomIdList("QP_INTERACTION_ID_LIST", interactionIds);
        return displayGroup;
    }

    @Override
    protected boolean onRightClick(@NotNull Location location, @NotNull Player player) {
        this.multiblockInteract(location.getBlock(), player);
        return true;
    }

    @Override
    public void onPoweredAnimation(@NotNull Location location, boolean powered) {
        this.brightnessAnimation(location.clone().add(COMPUTER_LOCATION), "main", powered);
        this.brightnessAnimation(location.clone().add(POWER_SUPPLY_LOCATION), "panel1", powered);
        this.brightnessAnimation(location.clone().add(POWER_SUPPLY_LOCATION), "panel2", powered);
    }

    @Override
    public Map<Vector, ItemStack> getStructure() {
        HashMap<Vector, ItemStack> structure = new HashMap<Vector, ItemStack>();
        structure.put(new Vector(0, -1, 0), (ItemStack)BeaconPowerSupply.BEACON_POWER_SUPPLY_1);
        structure.put(new Vector(0, 1, 0), (ItemStack)BeaconBeam.BEACON_BEAM);
        structure.put(new Vector(1, 1, 0), (ItemStack)BeaconTransmitter.BEACON_TRANSMITTER);
        structure.put(new Vector(-1, 1, 0), (ItemStack)BeaconTransmitter.BEACON_TRANSMITTER);
        structure.put(new Vector(0, 1, 1), (ItemStack)BeaconTransmitter.BEACON_TRANSMITTER);
        structure.put(new Vector(0, 1, -1), (ItemStack)BeaconTransmitter.BEACON_TRANSMITTER);
        structure.put(new Vector(0, 2, 0), (ItemStack)BeaconComputer.BEACON_COMPUTER);
        structure.put(new Vector(1, 2, 0), (ItemStack)BeaconPanel.BEACON_PANEL);
        structure.put(new Vector(-1, 2, 0), (ItemStack)BeaconPanel.BEACON_PANEL);
        structure.put(new Vector(0, 2, 1), (ItemStack)BeaconPanel.BEACON_PANEL);
        structure.put(new Vector(0, 2, -1), (ItemStack)BeaconPanel.BEACON_PANEL);
        structure.put(new Vector(0, 3, 0), (ItemStack)BeaconBeam.BEACON_BEAM);
        structure.put(new Vector(0, 4, 0), (ItemStack)BeaconTransmitter.BEACON_TRANSMITTER);
        return structure;
    }

    @Override
    public Vector getPowerSupplyLocation() {
        return POWER_SUPPLY_LOCATION;
    }

    @Override
    protected List<String> getModuleDisplayNames() {
        return List.of("module1", "module2");
    }
}

