/*
 * Decompiled with CFR 0.152.
 */
package org.metamechanists.quaptics.implementation.burnout;

import com.destroystokyo.paper.ParticleBuilder;
import io.github.thebusybiscuit.slimefun4.api.items.SlimefunItem;
import java.util.Optional;
import java.util.stream.IntStream;
import org.bukkit.Bukkit;
import org.bukkit.Location;
import org.bukkit.Particle;
import org.bukkit.Sound;
import org.bukkit.block.Block;
import org.bukkit.entity.Display;
import org.bukkit.plugin.Plugin;
import org.bukkit.scheduler.BukkitRunnable;
import org.jetbrains.annotations.NotNull;
import org.metamechanists.quaptics.Quaptics;
import org.metamechanists.quaptics.connections.ConnectionGroup;
import org.metamechanists.quaptics.displaymodellib.sefilib.entity.display.DisplayGroup;
import org.metamechanists.quaptics.implementation.base.ConnectedBlock;
import org.metamechanists.quaptics.implementation.base.QuapticBlock;
import org.metamechanists.quaptics.implementation.burnout.BurnoutManager;
import org.metamechanists.quaptics.utils.BlockStorageAPI;

public class BurnoutRunnable
extends BukkitRunnable {
    private static final int BURN_TIME_TICKS = 60;
    private static final float FIZZLE_VOLUME = 0.1f;
    private static final float FIZZLE_PITCH = 0.8f;
    private static final int INITIAL_BRIGHTNESS = 13;
    private final Location location;
    private final Location centerLocation;
    private boolean stopEarly;

    public BurnoutRunnable(@NotNull Location location) {
        this.location = location;
        this.centerLocation = location.toCenterLocation();
    }

    public void run() {
        SlimefunItem slimefunItem;
        Block block = this.location.getBlock();
        Optional<DisplayGroup> displayGroup = QuapticBlock.getDisplayGroup(this.location);
        Optional<ConnectionGroup> connectionGroup = ConnectedBlock.getGroup(this.location);
        if (displayGroup.isEmpty() || connectionGroup.isEmpty() || !((slimefunItem = BlockStorageAPI.check(block)) instanceof ConnectedBlock)) {
            return;
        }
        ConnectedBlock connectedBlock = (ConnectedBlock)slimefunItem;
        IntStream.range(1, 60).forEach(delay -> Bukkit.getScheduler().runTaskLater((Plugin)Quaptics.getInstance(), () -> this.tickDisplayGroup((DisplayGroup)displayGroup.get(), delay), (long)delay));
        Bukkit.getScheduler().runTaskLater((Plugin)Quaptics.getInstance(), () -> this.doFinalBurnout(connectedBlock), 60L);
    }

    private void tickDisplayGroup(@NotNull DisplayGroup displayGroup, int ticks) {
        if (this.shouldStopEarly()) {
            return;
        }
        if (ticks % 4 == 0) {
            this.location.getWorld().playSound(this.centerLocation, Sound.BLOCK_LAVA_EXTINGUISH, 0.1f, 0.8f);
        }
        if (ticks % 2 == 0) {
            this.doBurnoutAnimation(displayGroup);
        }
    }

    private void doBurnoutAnimation(@NotNull DisplayGroup displayGroup) {
        displayGroup.getDisplays().values().forEach(display -> {
            Display.Brightness oldBrightness = display.getBrightness();
            Display.Brightness newBrightess = new Display.Brightness(Optional.ofNullable(oldBrightness).map(brightness -> Math.max(0, brightness.getBlockLight() - 1)).orElse(13).intValue(), 0);
            display.setBrightness(newBrightess);
        });
        new ParticleBuilder(Particle.LAVA).location(this.centerLocation).spawn();
    }

    private void doFinalBurnout(ConnectedBlock connectedBlock) {
        if (this.shouldStopEarly()) {
            return;
        }
        connectedBlock.burnout(this.location);
        BurnoutManager.removeBurnout(this);
    }

    private boolean shouldStopEarly() {
        return this.stopEarly;
    }

    public void stopEarly() {
        this.stopEarly = true;
        Block block = this.location.getBlock();
        SlimefunItem slimefunItem = BlockStorageAPI.check(block);
        if (slimefunItem instanceof ConnectedBlock) {
            ConnectedBlock connectedBlock = (ConnectedBlock)slimefunItem;
            connectedBlock.burnout(this.location);
        }
        BurnoutManager.removeBurnout(this);
    }

    public Location getLocation() {
        return this.location;
    }

    public Location getCenterLocation() {
        return this.centerLocation;
    }
}

